% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/haplotype.likelihoods.R
\name{haplotype.likelihoods}
\alias{haplotype.likelihoods}
\title{Haplotype Likelihoods}
\usage{
haplotype.likelihoods(dna.seq, model = "raw", pairwise.deletion = FALSE)
}
\arguments{
\item{dna.seq}{a list of DNA sequences.}

\item{model}{a character string specifying the evolutionary model to be used. Passed to
\code{\link[ape]{dist.dna}}.}

\item{pairwise.deletion}{a logical indicating whether to delete the sites with missing data
  in a pairwise way. Passed to \code{\link[ape]{dist.dna}}.}
}
\value{
vector of delta(log-Likelihoods) for each haplotype, sorted from smallest to largest, and
  a plot of their distributions.
}
\description{
Calculate likelihood of each haplotype based on gamma distribution of pairwise distances.
}
\examples{
data(dolph.haps)
haplotype.likelihoods(dolph.haps)
}
\author{
Eric Archer \email{eric.archer@noaa.gov}
}

