% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/check.seqs.R
\name{check.seqs}
\alias{check.seqs}
\title{Run All Sequence QA/QC Tests}
\usage{
check.seqs(x, label, min.freq = 3, motif.length = 10, model = "raw",
  pairwise.deletion = FALSE)
}
\arguments{
\item{x}{either a .fasta file or list of sequences.}

\item{label}{label for output folder and prefix for files.}

\item{min.freq}{minimum frequency of base to be flagged.}

\item{motif.length}{length of motif around low frequency base to output.}

\item{model}{a character string specifying the evolutionary model to be used. Passed to
\code{\link[ape]{dist.dna}}.}

\item{pairwise.deletion}{a logical indicating whether to delete the sites with missing data
  in a pairwise way. Passed to \code{\link[ape]{dist.dna}}.}
}
\value{
Nothing is returned, but outputs are placed in a folder specified by \code{label}.
}
\description{
Produces haplotypic summaries, checks for low-frequency substitutions,
  and unusually distant sequences.
}
\author{
Eric Archer \email{eric.archer@noaa.gov}
}

