% Generated by roxygen2 (4.0.2): do not edit by hand
\name{check.gtypes}
\alias{check.gtypes}
\alias{gtypes}
\alias{gtypes.character}
\alias{gtypes.default}
\alias{gtypes.list}
\alias{is.gtypes}
\alias{stopifnot.gtypes}
\title{Create a gtypes object}
\usage{
check.gtypes(g, ploidy = "any")

gtypes(gen.data, ...)

\method{gtypes}{character}(gen.data, ...)

\method{gtypes}{default}(gen.data, id.col = 1, strata.col = 2,
  locus.col = 3, dna.seq = NULL, description = NULL,
  delete.missing.strata = TRUE, code.start = 0, ...)

\method{gtypes}{list}(gen.data, strata.vec, ...)

is.gtypes(x, show.warnings = TRUE)

stopifnot.gtypes(g, ploidy = "any")
}
\arguments{
\item{g}{a gtypes object.}

\item{ploidy}{character giving ploidy of gtypes object ("haploid", "diploid", or "any").}

\item{gen.data}{a \code{matrix}, \code{data.frame}, \code{list} of sequences, or filename where genetic data is stored}

\item{...}{arguments to the default method}

\item{id.col}{a number or character string specifying the column where sample IDs are located}

\item{strata.col}{a number of character string specifying the column where strata designations are located}

\item{locus.col}{a number specifying the first column of the genetic loci. All other loci are assumed to follow this column.}

\item{dna.seq}{a list of DNA sequences for haploid data}

\item{description}{a string naming or describing this dataset. Will be used in summaries and plots.}

\item{delete.missing.strata}{logical. Delete samples for which strata is missing (NA)?}

\item{code.start}{integer to start numeric recoding at. Must be >= 0.}

\item{strata.vec}{a character or numeric vector specifying the stratum that each sample should be assigned to.}

\item{x}{an R object to test.}

\item{show.warnings}{logical - show warnings for is.dna.seq describing check failures?}
}
\value{
a \code{gtypes} object which is a list containining the following elements: \cr
\tabular{ll}{
  \code{genotypes} \tab A numeric matrix where the first column ("strata") gives the stratification.
    If haploid, the second column in the matrix lists haplotypes. If diploid, every two columns afterwards
    are two alleles of the same locus.\cr
  \code{sequences} \tab If haploid, and provided on creation, a list of aligned DNA sequences. Otherwise \code{NULL}.\cr
}
}
\description{
Creates a coded list of stratified genotypes or haplotypes for use with
  most functions in the \code{strataG} package.
}
\note{
a gtypes object has the input strata and locus data coded numerically for ease of use in
  analytical functions. Mapping attributes \code{strata.name} and \code{locus.name} are available
  in each element. To map to the original data, one can use \code{\link{decode}}, \code{\link{as.matrix.gtypes}},
  or \code{\link{as.data.frame.gtypes}}, however, the resulting object from these cannot be used
  where a \code{gtypes} object is required.
}
\examples{
data(dolph.strata)
data(dolph.haps)
data(dolph.msats)

# Create gtypes object for mtDNA data
mtdna <- gtypes(dolph.strata, id.col = 1, strata.col = 2, locus.col = 4, dna.seq = dolph.haps)
summary(mtdna)

# Create gtypes object for microsatellite data
# First, merge strata file and genotypes
msat.merge <- merge(dolph.strata, dolph.msats, by = "ids", all.y = TRUE, sort = FALSE)
msats <- gtypes(msat.merge, id.col = 1, strata.col = 3, locus.col = 5, description = "msats")
summary(msats)
}
\author{
Eric Archer <eric.archer@noaa.gov>
}
\seealso{
\code{\link{decode}}, \code{\link{as.matrix.gtypes}}, \code{\link{as.data.frame.gtypes}}
}

