% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Leslie.pred.R
\name{Leslie.pred}
\alias{Leslie.pred}
\title{Project Leslie matrix}
\usage{
Leslie.pred(A, no, tmax = 100, pop.sum = FALSE)
}
\arguments{
\item{A}{A k * k projection matrix.}

\item{no}{A k * 1 population vector.}

\item{tmax}{Number of time steps to project the vector.}

\item{pop.sum}{Logical: If ’TRUE’, the age-classes of the projected population are summed, yielding a single total population vector}
}
\value{
If pop.sum=FALSE (the default), the value will be a k x tmax+1 matrix. The first column of the
matrix is no and each subsequent column represents the population structure at time step 1, 2, ..., tmax.
If pop.sum=TRUE, the value will be a vector of length tmax+1, where each element of the vector is
the total population at time t=0, 1, ..., tmax.
}
\description{
Projects an population vector tmax intervals by pre-multiplication with a Leslie matrix.
}
\details{
Takes an initial population vector, no, and pre-multiplies by the demographic projection matrix,
A, tmax times. This projection will be tmax*n years into the future, where n is the width of the
age-classes in the Leslie matrix, A.
}
\references{
Caswell, H. (2001). Matrix population models: Construction, analysis, and interpretation. 2nd ed. Sunderland, MA: Sinauer.

van Groenendael, J., De Kroon, H., Kalisz, S. and Tuljapurkar. S. (1994). Loop analysis: Evaluating life history pathways in population projection matrices. Ecology 75 (8):2410-2415.
}
\seealso{
\code{\link{Leslie.matrix}} \code{\link{eigen.analysis}}
}
\keyword{Leslie-matrix}
\keyword{projection}
