% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/osrmfunctions.R
\name{viaroute2sldf}
\alias{viaroute2sldf}
\title{Convert json result of OSRM routing query to SpatialLinesDataFrame}
\usage{
viaroute2sldf(osrmresult)
}
\arguments{
\item{osrmresult}{String containing encoded json result of OSRM routing
query.}
}
\description{
Convert json result of OSRM routing query to SpatialLinesDataFrame
}
\section{Details}{

Converts the result of a (successful) OSRM routing query and returns a
SpatialLinesDataFrame containing the route, route summary and instructions.
}
\examples{
\dontrun{
library(RCurl)
 viaroute2sldf(
   RCurl::getURL(paste0(
   "http://router.project-osrm.org/viaroute?loc=52.503033,13.420526&",
   "loc=52.516582,13.429290&instructions=true"))
 )
}
}

