% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_session_publications.R
\name{get_session_publications}
\alias{get_session_publications}
\title{Retrieve publications of a type in a parliamentary session}
\usage{
get_session_publications(sessionid = NA, type = "referat", good_manners = 0)
}
\arguments{
\item{sessionid}{Character string indicating the id of the hearing to retrieve.}

\item{type}{Character specifying type of publication to download. Available types are "referat" (minutes),
"innstilling" (proposition), "innberetning" (report), "lovvedtak" (law decision), "lovanmerkning" (law note),
"dok8" (MP proposal) "dok12" (Constitutional proposal), and "dokumentserie" (document series).
Defaults to "referat".}

\item{good_manners}{Integer. Seconds delay between calls when making multiple calls to the same function}
}
\value{
A data.frame with the following variables:\tabular{ll}{
    \tab  \cr
   \strong{response_date} \tab Date of data retrieval \cr
   \strong{version} \tab Data version from the API \cr
   \strong{session_id} \tab Session id \cr
   \strong{publication_date} \tab Date of publication \cr
   \strong{publication_id} \tab Id of publication \cr
   \strong{publication_format} \tab Publication format (XML) \cr
   \strong{publication_available_date} \tab When the publication was made available \cr
   \strong{publication_title} \tab Publication title \cr
   \strong{publication_type} \tab Publication type \cr
}
}
\description{
A function for retrieving one of several publication types within a parliamentary session.
}
\examples{

\dontrun{

pub <- get_session_publications("1998-99")
head(pub)

}


}
\seealso{
\link{get_publication}
}
