% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/my_wind_code.R
\name{calc_grid_wind}
\alias{calc_grid_wind}
\title{Calculate wind speed at grid points}
\usage{
calc_grid_wind(grid_point = stormwindmodel::county_points[1, ],
  with_wind_radii = add_wind_radii())
}
\arguments{
\item{grid_point}{A one-row dataframe with the grid id, latitude, and
longitude for a single location for which you want to model winds.}

\item{with_wind_radii}{A dataframe of storm tracks, including inputs and
parameters for the Willoughby wind model, as created by
\code{\link{add_wind_radii}}.}
}
\value{
A dataframe with date (\code{date}) and modeled wind speed
   (\code{windspeed}, in m / s) at the grid point location for all storm
   observations.
}
\description{
Uses the Willoughby wind model (Willoughby et al. 2006) to calculate wind
speed at a grid point location. This function calculates a wind time series at
just one location.
}
\examples{
\dontrun{
data("floyd_tracks")
data("county_points")
full_track <- create_full_track(hurr_track = floyd_tracks)
with_wind_radii <- add_wind_radii(full_track = full_track)
wind_grid <- calc_grid_wind(grid_point = county_points[1, ],
                            with_wind_radii = with_wind_radii)
head(wind_grid)
}

}
\references{
Knaff JA, DeMaria M, Molenar DA, Sampson CR, and Seybold MG. 2011. An
automated, objective, multiple-satellite-platform tropical cyclone surface
wind speed analysis. Journal of Applied Meteorology and Climatology
50(10):2149-2166

Phadke AC, Martino CD, Cheung KF, and Houston SH. 2003. Modeling of
   tropical cyclone winds and waves for emergency management. Ocean
   Engineering 30(4):553-578.

Willoughby HE, Darling RWR, and Rahn ME. 2006. Parametric representation
of the primary hurricane vortex. Part II: A new family of sectionally
continuous profiles. Monthly Weather Review 134(4):1102-1120.
}

