% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lines.rule.surv.R
\name{lines.rule.surv}
\alias{lines.rule.surv}
\title{Add Stopping Rule Curve to Current Plot (Survival Data)}
\usage{
\method{lines}{rule.surv}(x, ...)
}
\arguments{
\item{x}{A \code{rule.surv} object calculated by \code{calc.rule.surv()} function}

\item{...}{Other options to be passed to generic \code{lines()} function}
}
\value{
No return value, function solely modifies current plot
}
\description{
Add a survival stopping rule graphically as a curve on current plot for time-to-event data
}
\examples{
\dontrun{poc_rule = calc.rule.surv(n=50,p0=0.20,alpha=0.10,type="Pocock",tau=100)
gp_rule = calc.rule.surv(n=50,p0=0.20,alpha=0.10,type="GP",tau=100,param=c(1,1000))
plot(poc_rule)
lines(gp_rule,col="red")
}
}
