% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc.bnd.surv.R
\name{calc.bnd.surv}
\alias{calc.bnd.surv}
\title{Stopping Boundary Calculation (Survival Data)}
\usage{
calc.bnd.surv(n, p0, type, tau, cval, param = NULL)
}
\arguments{
\item{n}{Maximum sample size for safety monitoring}

\item{p0}{The probability of a toxicity occurring in \code{tau} units of time under the null hypothesis}

\item{type}{The method used for constructing the stopping rule}

\item{tau}{Length of observation period}

\item{cval}{Critical value for the stopping rule. For Wang-Tsiatis tests, this is the Delta parameter. For the Bayesian Gamma-Poisson method, this is the threshold on the posterior probability. For the truncated SPRT, this is the threshold on the log likelihood ratio. For the MaxSPRT, this is the threshold on the log generalized likelihood ratio.}

\item{param}{A vector of the extra parameter(s) needed for certain stopping rule methods. For Wang-Tsiatis tests, this is the Delta parameter. For truncated SPRT, this is the targeted alternative toxicity probability p1. For Bayesian Gamma-Poisson model, this is the vector of hyperparameters (shape,rate) for the gamma prior on the toxicity event rate.}
}
\value{
A list of three items: tau, number of events that can trigger a stop, and the corresponding total follow up time.
}
\description{
Internal workhorse function to calculate stopping boundary for a given method for time-to-event data
}
