% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/optSV.R
\name{estimate_parameters}
\alias{estimate_parameters}
\title{Estimate parameters for the stochastic volatility model}
\usage{
estimate_parameters(data, model = "gaussian", opt.control = NULL, ...)
}
\arguments{
\item{data}{A vector of observations.}

\item{model}{A character specifying the model. Must be one of the following:
"gaussian", "t", "leverage", "skew_gaussian".}

\item{opt.control}{An optional list of parameters for nlminb.}

\item{...}{additional arguments passed to \link[TMB]{MakeADFun}.}
}
\value{
Object of class \code{stochvolTMB}
}
\description{
Estimate parameters of a stochastic volatility model with a latent 
log-volatility following an 
autoregressive process of order one with normally distributed noise. 
The following distributions are implemented for the observed process: 

\itemize{
\item Gaussian distribution
\item t-distribution
\item Leverage: Gaussian distribution with leverage where the noise of the latent process is correlated with the
 observational distribution
\item Skew gaussian distribution
}

The parameters is estimated by minimizing the negative log-likelihood (nll) and the latent log-volatility is 
integrated out by applying the Laplace approximation.
}
\examples{
# load data
data("spy")

# estimate parameters 
opt <- estimate_parameters(spy$log_return, model = "gaussian")

# get parameter estimates with standard error
estimates <- summary(opt)

# plot estimated volatility with 95 \% confidence interval
plot(opt, include_ci = TRUE)

}
