% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers_t_test_expressions.R
\name{expr_t_robust}
\alias{expr_t_robust}
\title{Expression containing results from a robust \emph{t}-test}
\usage{
expr_t_robust(
  data,
  x,
  y,
  paired = FALSE,
  k = 2L,
  conf.level = 0.95,
  tr = 0.1,
  nboot = 100,
  stat.title = NULL,
  ...
)
}
\arguments{
\item{data}{A dataframe (or a tibble) from which variables specified are to
be taken. A matrix or tables will \strong{not} be accepted.}

\item{x}{The grouping variable from the dataframe \code{data}.}

\item{y}{The response (a.k.a. outcome or dependent) variable from the
dataframe \code{data}.}

\item{paired}{Logical that decides whether the experimental design is
repeated measures/within-subjects or between-subjects. The default is
\code{FALSE}.}

\item{k}{Number of digits after decimal point (should be an integer)
(Default: \code{k = 2}).}

\item{conf.level}{Scalar between 0 and 1. If unspecified, the defaults return
\verb{95\%} lower and upper confidence intervals (\code{0.95}).}

\item{tr}{Trim level for the mean when carrying out \code{robust} tests. If you
get error stating "Standard error cannot be computed because of Winsorized
variance of 0 (e.g., due to ties). Try to decrease the trimming level.",
try to play around with the value of \code{tr}, which is by default set to
\code{0.1}. Lowering the value might help.}

\item{nboot}{Number of bootstrap samples for computing confidence interval
for the effect size (Default: \code{100}).}

\item{stat.title}{A character describing the test being run, which will be
added as a prefix in the subtitle. The default is \code{NULL}. An example of a
\code{stat.title} argument will be something like \code{"Student's t-test: "}.}

\item{...}{Additional arguments (currently ignored).}
}
\description{
Expression containing results from a robust \emph{t}-test
}
\examples{
\donttest{
# for reproducibility
set.seed(123)

# between-subjects design -----------------------------------------------

# with defaults
statsExpressions::expr_t_robust(
  data = sleep,
  x = group,
  y = extra
)

# changing defaults
statsExpressions::expr_t_robust(
  data = ToothGrowth,
  x = supp,
  y = len,
  nboot = 10,
  k = 3,
  tr = 0.2
)

# within-subjects design -----------------------------------------------
statsExpressions::expr_t_robust(
  data = dplyr::filter(bugs_long, condition \%in\% c("LDLF", "LDHF")),
  x = condition,
  y = desire,
  paired = TRUE,
  nboot = 25
)
}
}
\references{
For more details, see-
\url{https://indrajeetpatil.github.io/statsExpressions/articles/stats_details.html}
}
