% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers_bf_tests.R
\name{bf_oneway_anova}
\alias{bf_oneway_anova}
\title{Bayesian one-way analysis of variance.}
\usage{
bf_oneway_anova(
  data,
  x,
  y,
  bf.prior = 0.707,
  caption = NULL,
  output = "null",
  paired = FALSE,
  k = 2,
  ...
)
}
\arguments{
\item{data}{A dataframe (or a tibble) from which variables specified are to
be taken. A matrix or tables will \strong{not} be accepted.}

\item{x}{The grouping variable from the dataframe \code{data}.}

\item{y}{The response (a.k.a. outcome or dependent) variable from the
dataframe \code{data}.}

\item{bf.prior}{A numeric value between \code{0.5} and \code{2} (default \code{0.707}), the
prior width to use in calculating Bayes Factors.}

\item{caption}{Text to display as caption (will be displayed on top of the
Bayes Factor caption/message).}

\item{output}{Can either be \code{"null"} (or \code{"caption"} or \code{"H0"} or \code{"h0"}),
which will return expression with evidence in favor of the null hypothesis,
or \code{"alternative"} (or \code{"title"} or \code{"H1"} or \code{"h1"}), which will return
expression with evidence in favor of the alternative hypothesis, or
\code{"results"}, which will return a dataframe with results all the details).}

\item{paired}{Logical that decides whether the experimental design is
repeated measures/within-subjects or between-subjects. The default is
\code{FALSE}.}

\item{k}{Number of digits after decimal point (should be an integer)
(Default: \code{k = 2}).}

\item{...}{Additional arguments.}
}
\description{
Bayesian one-way analysis of variance.
}
\examples{
\donttest{

# between-subjects -------------------------------------------------------

# to get caption (default)
bf_oneway_anova(
  data = iris,
  x = Species,
  y = Sepal.Length,
  bf.prior = 0.8,
  paired = FALSE
)

# to get results dataframe
bf_oneway_anova(
  data = iris,
  x = Species,
  y = Sepal.Length,
  bf.prior = 0.8,
  output = "results"
)

# within-subjects -------------------------------------------------------
bf_oneway_anova(
  data = bugs_long,
  x = condition,
  y = desire,
  paired = TRUE
)
}
}
\seealso{
\code{\link{bf_contingency_tab}}, \code{\link{bf_corr_test}},
\code{\link{bf_ttest}}
}
\author{
\href{https://github.com/IndrajeetPatil}{Indrajeet Patil}
}
