% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statpsych2.R
\name{size.ci.cronbach2}
\alias{size.ci.cronbach2}
\title{Sample size for a 2-group Cronbach reliability difference confidence
interval}
\usage{
size.ci.cronbach2(alpha, rel1, rel2, r, w)
}
\arguments{
\item{alpha}{alpha level for hypothesis test}

\item{rel1}{group 1 reliability planning value}

\item{rel2}{group 2 reliability planning value}

\item{r}{number of measurements (items, raters)}

\item{w}{desired confidence interval width}
}
\value{
Returns the required sample size per group
}
\description{
Computes the sample size required to estimate a difference in population
Cronbach reliability coefficients with desired precision in a 2-group
design.
}
\examples{
size.ci.cronbach2(.05, .85, .70, 8, .15)

# Should return:
#      Sample size per group
# [1,]                   180
 

}
\references{
\insertRef{Bonett2015}{statpsych}
}
