% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statpsych1.R
\name{ci.mann}
\alias{ci.mann}
\title{Confidence interval for a Mann-Whitney parameter}
\usage{
ci.mann(alpha, y1, y2)
}
\arguments{
\item{alpha}{alpha level for 1-alpha confidence}

\item{y1}{vector of scores for group 1}

\item{y2}{vector of scores for group 2}
}
\value{
Returns a 1-row matrix. The columns are:
\itemize{
\item Estimate - estimate of probability
\item SE - standard error
\item LL - lower limit of the confidence interval
\item UL - upper limit of the confidence interval
}
}
\description{
Computes a distribution-free confidence interval for the Mann-Whitney
parameter (a "common language effect size"). In a 2-group experiment, this
parameter is the proportion of members in the population with scores that
would be higher under treatment 1 than treatment 2. In a 2-group
nonexperiment where participants are sampled from two subpopulations of
sizes N1 and N2, the parameter is the proportion of all N1 x N2 pairs in
which a member from subpopulation 1 has a larger score than a member from
subpopulation 2.
}
\examples{
y2 <- c(36, 44, 47, 42, 49, 39, 46, 31, 33, 48)
y1 <- c(32, 39, 26, 35, 43, 27, 40, 37, 34, 29)
ci.mann(.05, y1, y2)

# Should return:
#      Estimate        SE        LL UL
# [1,]    0.795 0.1401834 0.5202456  1


}
\references{
\insertRef{Sen1967}{statpsych}
}
