% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasets.R
\name{sp_get_dataset_url}
\alias{sp_get_dataset_url}
\title{Get URL of dataset}
\usage{
sp_get_dataset_url(dataset_id, year, month = 12, check_if_exists = TRUE)
}
\arguments{
\item{dataset_id}{Dataset ID. See \code{id} column in \code{sp_datasets} for a list of available codelists.}

\item{year}{year, numeric vector of length <= 1 (can take multiple values), 2015-2019 for some datasets, 2010-2020 for others.
(see Details for how to work with data across time periods.)}

\item{month}{month, numeric vector of length <= 1 (can take multiple values). Must be between 1 and 12. Defaults to 12.
(see Details for how to work with data across time periods.)}

\item{check_if_exists}{Whether to check that the URL works (HTTP 200).}
}
\value{
a character vector of length one, containing a URL
}
\description{
Useful for workflows where you want to keep track of URLs and intermediate files, rather
than having all steps performed by one function.
}
\examples{
\dontrun{
sp_get_dataset_url("finm", 2018, 6, FALSE)
sp_get_dataset_url("finm", 2029, 6, FALSE) # works but returns invalid URL
if(FALSE) sp_get_dataset_url("finm_wrong", 2018, 6, TRUE) # fails, invalid dataset ID
if(FALSE) sp_get_dataset_url("finm", 2022, 6, TRUE) # fails, invalid time period
}
}
\seealso{
Other Detailed workflow: 
\code{\link{sp_get_codelist_file}()},
\code{\link{sp_get_table_file}()},
\code{\link{sp_load_codelist}()},
\code{\link{sp_load_table}()}
}
\concept{Detailed workflow}
