% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extractSTA.R
\name{extractSTA}
\alias{extractSTA}
\title{Extract statistics from fitted models}
\usage{
extractSTA(
  STA,
  trials = names(STA),
  traits = NULL,
  what = "all",
  asDataFrame = length(what) == 1 && what != "all",
  keep = NULL,
  restoreColNames = FALSE
)
}
\arguments{
\item{STA}{An object of class STA.}

\item{trials}{A character vector of trials for which the statistics should be
computed. If not supplied, statistics are computed for all trials that have
been modeled.}

\item{traits}{A character vector of traits for which the statistics should be
computed. If not supplied, statistics are computed for all traits that have
been modeled.}

\item{what}{A character vector indicating which statistics should be
computed. Most statistics are available for all models, some only for models
fitted using a certain engine. If this is the case, this is indicated in the
list with options in details.\cr
If \code{what = "all"}, all available statistics are computed.}

\item{asDataFrame}{Should the output be reshaped to a data.frame. This is
only possible if the number of statistics to extract is one.}

\item{keep}{A character vector of column(s) in the object of class
\code{\link{TD}} used for modeling. These columns will be kept as output when
computing fitted values, residuals, standardized residuals and rMeans.
Columns can also be kept when computing (se)BLUEs and (se)BLUPs but only if
the column to keep contains unique values for the modeled variables, i.e. a
column repId with several different values per genotype cannot be kept.}

\item{restoreColNames}{Should the original column names be restored in the
output of the extracted data?}
}
\value{
Depending on the input either a data.frame or a list with, per
trial for which statistics have been extracted, a list of those statistics.
}
\description{
Extract and calculate various results for fitted models such as BLUEs, BLUPs,
unit errors and heritabilities. For a full list of results that can be
extracted, see the table below.\cr\cr
The result(s) to extract can be specified in \code{what}.\cr
If a single result is extracted, this result is returned as a
\code{data.frame}, If this is not possible, because the format of the result
is incompatible with the \code{data.frame} format, the result is returned as
a list. E.g. if BLUEs are extracted, the output of the function is a
\code{data.frame} with BLUEs. However if varCompF is extracted, the
output of the function is a \code{list}.\cr\cr
Results that are returned as \code{data.frame} are marked as such in the
asDataFrame column in the table. If the default return value for a result
is a \code{data.frame} that can be overridden by the user by specifying
\code{asDataFrame = FALSE}. When doing so the result will be returned as a
list of data.frames, one per trial. They other way round is not possible.
If a result is returned as a \code{list} according to the table, it cannot
be returned as a \code{data.frame}.\cr
If multiple results are extracted at the same time, these are always
returned as a list.
\cr\cr
Most results can only be calculated if a model is fitted with genotype as
fixed or with genotype as random. E.g. to compute heritabilities a model
should be fitted with genotype as random effect. This is indicated in the
table in the column model with "F" and "R" respectively.

Possible options for \code{what} are:\tabular{llll}{
   result \tab model \tab description \tab asDataFrame \cr
   BLUEs \tab F \tab Best Linear Unbiased Estimators \tab yes \cr
   seBLUEs \tab F \tab standard errors of the BLUEs \tab yes \cr
   ue \tab F \tab unit errors - only for lme4 and asreml \tab yes \cr
   varCompF \tab F \tab variance components for the model with genotype as fixed component \tab  \cr
   fitted \tab F \tab fitted values for the model with genotype as fixed component \tab yes \cr
   residF \tab F \tab residuals for the model with genotype as fixed component \tab yes \cr
   stdResF \tab F \tab standardized residuals for the model with genotype as fixed component \tab yes \cr
   wald \tab F \tab results of the wald test - only for lme4 and asreml \tab  \cr
   CV \tab F \tab Coefficient of Variation - only for lme4 and asreml \tab yes \cr
   rDfF \tab F \tab residual degrees of freedom for the model with genotype as fixed component \tab yes \cr
   sed \tab F \tab standard error of difference - only for asreml \tab  \cr
   lsd \tab F \tab least significant difference - only for asreml \tab  \cr
   BLUPs \tab R \tab Best Linear Unbiased Predictors \tab yes \cr
   seBLUPs \tab R \tab standard errors of the BLUPs \tab yes \cr
   heritability \tab R \tab broad sense heritability \tab yes \cr
   varCompR \tab R \tab variance components for the model with genotype as random component \tab  \cr
   varGen \tab R \tab genetic variance component \tab yes \cr
   varErr \tab R \tab residual variance component \tab yes \cr
   varSpat \tab R \tab spatial variance components - only for SpATS \tab  \cr
   rMeans \tab R \tab fitted values for the model with genotype as random component \tab yes \cr
   ranEf \tab R \tab random genetic effects \tab yes \cr
   residR \tab R \tab residuals for the model with genotype as random component \tab yes \cr
   stdResR \tab R \tab standardized residuals for the model with genotype as random component \tab yes \cr
   rDfR \tab R \tab residual degrees of freedom for the model with genotype as random component \tab yes \cr
   effDim \tab R \tab effective dimensions - only for SpATS \tab  \cr
   ratEffDim \tab R \tab ratios of the effective dimensions - only for SpATS \tab  \cr
}
}
\examples{
## Fit model using SpATS.
modSp <- fitTD(TD = TDHeat05,
               design = "res.rowcol",
               traits = "yield")

## Extract all available statistics from the fitted model.
extr <- extractSTA(modSp)

## Extract only the BLUEs from the fitted model.
BLUEs <- extractSTA(modSp,
                    what = "BLUEs")

## Extract only the BLUEs from the fitted model and keep trial as variable in
## the output.
BLUEs2 <- extractSTA(modSp,
                     what = "BLUEs",
                     keep = "trial")

}
\seealso{
\code{\link{fitTD}}
}
