% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statGraph.R
\name{takahashi.test}
\alias{takahashi.test}
\title{Test for the Jensen-Shannon divergence between graphs}
\usage{
takahashi.test(G1, G2, maxBoot = 1000, bandwidth = "Silverman")
}
\arguments{
\item{G1}{a list of undirected graphs (igraph type) or their adjacency
matrices. The adjacency matrix of an unweighted graph contains only 0s and
1s, while the weighted graph may have nonnegative real values that correspond
to the weights of the edges.}

\item{G2}{a list of undirected graphs (igraph type) or their adjacency
matrices. The adjacency matrix of an unweighted graph contains only 0s and
1s, while the weighted graph may have nonnegative real values that correspond
to the weights of the edges.}

\item{maxBoot}{integer indicating the number of bootstrap resamplings.}

\item{bandwidth}{string showing which criterion is used to choose the
bandwidth during the spectral density estimation. Choose between the
following criteria: "Silverman" (default), "Sturges", "bcv", "ucv" and "SJ".
"bcv" is an abbreviation of biased cross-validation, while "ucv" means
unbiased cross-validation. "SJ"  implements the methods of Sheather & Jones
(1991) to select the bandwidth using pilot estimation of derivatives.}
}
\value{
A list containing:
\item{JSD}{the Jensen-Shannon divergence between 'G1' and 'G2'.}
\item{p.value}{the p-value of the test.}
}
\description{
\code{takahashi.test} tests whether two sets of graphs were generated by the same
random graph model.
This bootstrap test is based on the Jensen-Shannon (JS) divergence between
graphs.
}
\details{
Given two lists of graphs, 'G1' and 'G2', 'takahashi.test' tests H0: "JS
divergence between 'G1' and 'G2' is 0" against H1: "JS divergence between
'G1' and 'G2' is larger than 0".
}
\examples{
set.seed(1)
G1 <- G2 <- list()
for (i in 1:20) {
  G1[[i]] <- igraph::sample_gnp(n=50, p=0.5)
}
for (i in 1:20) {
  G2[[i]] <- igraph::sample_gnp(n=50, p=0.51)
}
result <- takahashi.test(G1, G2, maxBoot=100)
result

}
\references{
Takahashi, D. Y., Sato, J. R., Ferreira, C. E. and Fujita A. (2012)
Discriminating Different Classes of Biological Networks by Analyzing the
Graph Spectra  Distribution. _PLoS ONE_, *7*, e49949.
doi:10.1371/journal.pone.0049949.

Silverman, B. W. (1986) _Density Estimation_.  London: Chapman and Hall.

Sturges, H. A. The Choice of a Class Interval. _J. Am. Statist. Assoc._,
*21*, 65-66.

Sheather, S. J. and Jones, M. C. (1991). A reliable data-based bandwidth
selection method for kernel density estimation.
_Journal of the Royal Statistical Society series B_, 53, 683-690.
http://www.jstor.org/stable/2345597.
}
\keyword{graph_comparison}
