% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotBar.R
\name{plotBar}
\alias{plotBar}
\title{Generate a barplot of a Structure or Admixture run.}
\usage{
plotBar(x, populations = NULL, plot = TRUE, facet = TRUE)
}
\arguments{
\item{x}{an object of type \code{\link{struct}} or \code{\link{admix}} or a Q-matrix}

\item{populations}{a data.frame that contains the sample number as the first column and the population as the second.}

\item{plot}{if FALSE returns a data.frame for customised plots}

\item{facet}{whether or not to split the barplot by cluster. This is recommended.}
}
\description{
Generate a barplot of a Structure or Admixture run.
}
\examples{
# Read file using K = 6 and plot results
k6_data <- exampleStructure("barplot")
# Generate standard 'structure' barplot
plotBar(k6_data, facet = FALSE)
# adding group information
set.seed(212)
pops <- data.frame(id = k6_data$ancest_df[,1],
population = sample(letters[1:3], nrow(k6_data$ancest_df), replace = TRUE))
# our facetted structure plot
plotBar(k6_data, pops)
# standard 'structure' bar plot
plotBar(k6_data, pops, facet = FALSE)
#' admixture example
k3_data <- exampleAdmixture()[[3]]
plotBar(k3_data)
}

