% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/4-model-selection.R
\name{join_unobserved}
\alias{join_unobserved}
\title{Join situations with no observations}
\usage{
join_unobserved(
  object,
  fit = TRUE,
  trace = 0,
  name = "UNOBSERVED",
  scope = sevt_varnames(object)[-1],
  lambda = object$lambda
)
}
\arguments{
\item{object}{an object of class \code{sevt} with associated data.}

\item{fit}{if TRUE update model's probabilities.}

\item{trace}{if \code{> 0} print information to console.}

\item{name}{character, name for the new stage storing unobserved situations.}

\item{scope}{character vector, list of variables in \code{object}.}

\item{lambda}{smoothing parameter for the fitting.}
}
\value{
a staged event tree with at most one stage per variable with
no observations.
If, as default, \code{fit=TRUE} the model will be re-fitted, if
\code{fit=FALSE} probabilities in the output model are not estimated.
}
\description{
Join situations with no observations
}
\details{
It takes as input a (fitted) staged event tree object
and  it joins,
in the same stage, all the situations with zero
recorded observations.
Since such joining does not change
the log-likelihood of the model, it is a useful (time-wise)
pre-processing prior to others model selection algorithms.

Unobserved situations can be joined directly in
\code{\link{full}} or \code{\link{indep}}, by setting
\code{join_unobserved = TRUE}.
}
\examples{
DD <- generate_xor_dataset(n = 5, N = 10)
model_full <- full(DD, lambda = 1, join_unobserved = FALSE)
model <- join_unobserved(model_full)
logLik(model_full)
logLik(model)
BIC(model_full, model)
}
