% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parafac_functions.R
\name{eempf_OF_upload}
\alias{eempf_OF_upload}
\title{Upload PARAFAC models to openfluor.org}
\usage{
eempf_OF_upload(email, file)
}
\arguments{
\item{email}{email address you use to login at openfluor.org as string}

\item{file}{the file containing a PARAFAC model in openfluor format}
}
\value{
HTTP status code from the upload POST
}
\description{
This function uploads a PARAFAC model to openfluor.org from within R. You need to have an account at openfluor.org and supply the email used for the account to the function. Your password is then asked in a secure way and only used within one execution of this function.
}
\examples{
## due to the need of a valid account, this function cannot be
## tested with generic data.
## Please use your own account to do so.
\dontrun{
data(pf_models)

file <- file.path(tempdir(),"openfluor_example.txt")
eempf_openfluor(pf4[[1]],file)
eempf_OF_upload("helena.glory@rur.play", file)
}
}
