% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parafac_functions.R
\name{eem_exclude}
\alias{eem_exclude}
\title{Exclude complete wavelengths or samples form data set}
\usage{
eem_exclude(eem_list, exclude = list())
}
\arguments{
\item{eem_list}{object of class eemlist}

\item{exclude}{list of three vectors, see details}
}
\value{
object of class eemlist
}
\description{
Outliers in all modes should be avoided. With this functions excitation or emission wavelengths as well as samples can be removed completely from your sample set.
}
\details{
The argument exclude is a named list of three vectors. The names must be "ex", "em" and "sample". Each element contains a vector of wavelengths or sample names that are to be excluded from the data set.
}
\examples{
data(eem_list)

exclude <- list("ex" = c(280,285,290,295),
"em" = c(),
"sample" = c("sample3","sample5","sample14")
)

eem_list_ex <- eem_exclude(eem_list, exclude)
}
