% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/age_calc.R
\name{age_calc}
\alias{age_calc}
\title{Calculate age in years, months, or days}
\source{
\doi{10.18637/jss.v093.i02}
}
\usage{
age_calc(dob, enddate = Sys.Date(), units = "years", precise = TRUE)
}
\arguments{
\item{dob}{Date of birth}

\item{enddate}{End date for age calculation (default is Sys.Date())}

\item{units}{Units for age calculation (default is "years").
Can be c("days", "months", "years")}

\item{precise}{Option to calculate age precisely (default is TRUE)}
}
\value{
numeric vector length 1
}
\description{
Calculate age in years, months, or days
}
\examples{
trunc(age_calc(as.Date("1945-10-23"),as.Date("2018-09-30")))

}
\references{
Becker, J.P. (2020). eeptools: An R Package for Teaching and Learning
Ecology and Evolutionary Biology. Journal of Statistical Software,
93(2), 1-27.
}
\keyword{age}
\keyword{date}
\keyword{time}
