% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sstModel-base.R
\name{sstModel}
\alias{sstModel}
\title{Constructing an sstModel}
\usage{
sstModel(portfolio, market.risk, life.risk = NULL, health.risk = NULL,
  nonlife.risk = NULL, scenario.risk = NULL, participation.risk = NULL,
  macro.economic.scenarios = NULL, nhmr = NULL, reordering.parameters,
  standalones = NULL)
}
\arguments{
\item{portfolio}{a portfolio S3 object.}

\item{market.risk}{a marketRisk S3 object.}

\item{life.risk}{a lifeRisk S3 object. This can be \code{NULL} in case no lifeRisk
is considered.}

\item{health.risk}{a healthRisk S3 object. This can be \code{NULL} in case no healthRisk
is considered.}

\item{nonlife.risk}{a nonLifeRisk S3 object. This can be \code{NULL} in case no nonLifeRisk
is considered.}

\item{scenario.risk}{a scenarioRisk S3 object. This can be \code{NULL} in case no scenarioRisk
is considered.}

\item{participation.risk}{a participationRisk S3 object. This can be \code{NULL} in case no participationRisk
is considered.}

\item{macro.economic.scenarios}{a macroEconomicScenarios S3 object. This should be compatible with
the portfolio and the marketRisk, please consult \code{?macroEconomicScenarios} for more
information.}

\item{nhmr}{\code{NULL} or numeric value of length one and in [0, 1]. The factor for
non-headgeable market risk for market value margin computation.}

\item{reordering.parameters}{list of reordering information containing the following fields
\itemize{
  \item \code{list.correlation.matrix}: list of correlation matrices. The list should contain at least one correlation
    matrix named \code{"base"} (in first position) representing the base correlation from which ranks are simulated (with the associated Gaussian
    copula). If no additional correlation matrix is provided, a simple Gaussian reordering is applied. If additional named correlation matrices
    are provided then conditional reordering with stressed Gaussian copulas is applied. The names of the extra correlation matrices
    correspond to the names of the stressed-scenarios. In any case the rownames and colnames
    of the correlation matrices should be
    \code{c("market", "life", "health", "nonlife")}.
  \item \code{region.boundaries}: matrix with colnames corresponding to the risks (respecting the prescribed order)
    \code{c("market", "life", "health", "nonlife")} and rownames to the scenarios names
    (the names of the extra correlation matrices provided in the list \code{list.correlation.matrix}).
    This should be \code{NULL} in the case of a simple Gaussian reordering (i.e. \code{list.correlation.matrix}
    contains only a single element named \code{"base"}).
  \item \code{region.probability} a numeric value of probabilities (one for each extra scenario) giving the probability that the
    base Gaussian copula (represented by the correlation matrix named \code{"base"} in \code{list.correlation.matrix}) takes its values within
    the extreme regions (rectangles). This should be \code{NULL} in case of a simple Gaussian reordering.
  \item \code{scenario.probability} a numeric value of probabilities (one for each extra scenario) giving the probabilities
    of each scenario. This should be \code{NULL} in the case of a simple Gaussian reordering.
}}

\item{standalones}{a list of standalone S3 objects. Please note that names of standalones
should not appear in base market risk factors names in \code{market.risk}.}
}
\value{
an S3 object, instance of the class sstModel.
}
\description{
Constructor for the S3 class sstModel (main class of the package). It allows to build
  for a Swiss Solvency Test Model (SST model aggregating risk information with
  a portfolio description).
}
\note{
\code{portfolio} and \code{market.risk} should have the same
  base currency. Moreover, all risks should be consistent between
  them and the portfolio should be consistent with all risks. Note also that more information
  on the reordering can be found in the help page of the function \code{\link{conditionalReordering}}.
}
\seealso{
\code{\link{summary.sstModel}}, \code{\link{print.sstModel}}.
}
