% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/burrIII3.R
\name{burrIII3}
\alias{burrIII3}
\alias{dburrIII3}
\alias{qburrIII3}
\alias{pburrIII3}
\alias{rburrIII3}
\alias{sburrIII3}
\title{Burr Type III Three-Parameter Distribution}
\usage{
dburrIII3(x, lshape1 = 0, lshape2 = 0, lscale = 1, log = FALSE)

qburrIII3(
  p,
  lshape1 = 0,
  lshape2 = 0,
  lscale = 1,
  lower.tail = TRUE,
  log.p = FALSE
)

pburrIII3(
  q,
  lshape1 = 0,
  lshape2 = 0,
  lscale = 1,
  lower.tail = TRUE,
  log.p = FALSE
)

rburrIII3(n, lshape1 = 0, lshape2 = 0, lscale = 1)

sburrIII3(x)
}
\arguments{
\item{x}{A numeric vector of values.}

\item{lshape1}{shape1 parameter on the log scale.}

\item{lshape2}{shape2 parameter on the log scale.}

\item{lscale}{scale parameter on the log scale.}

\item{log}{logical; if TRUE, probabilities p are given as log(p).}

\item{p}{vector of probabilities.}

\item{lower.tail}{logical; if TRUE (default), probabilities are P[X <= x],otherwise, P[X > x].}

\item{log.p}{logical; if TRUE, probabilities p are given as log(p).}

\item{q}{vector of quantiles.}

\item{n}{number of observations.}
}
\value{
A numeric vector.
}
\description{
Density, distribution function, quantile function, random generation
and starting values for the
Burr Type III Three-Parameter distribution
with \code{lshape} and \code{lscale} parameters.
}
\details{
The Burr 12 distribution from the actuar package is used as a base.
The Burr III distribution is the distribution of 1/x where x has the Burr Type 12 distribution.
refer to https://www.itl.nist.gov/div898/software/dataplot/refman2/auxillar/bu3pdf.htm for details.
The shape1, shape2, and scale parameters are on the log(scale) as these must be positive.
}
\examples{
x <- seq(0.01, 5, by = 0.01)
plot(x, dburrIII3(x), type = "l")
}
\seealso{
\code{\link[actuar]{dburr}} and \code{\link{burrIII2}}
}
