% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sample_wtatage.R
\name{sample_wtatage}
\alias{sample_wtatage}
\title{Sample empirial weight-at-age data and write to file for use by the EM}
\usage{
sample_wtatage(wta_file_in, outfile, dat_list, ctl_file_in, years,
  fill_fnc = fill_across, write_file = TRUE, fleets, cv_wtatage = NULL)
}
\arguments{
\item{wta_file_in}{The file to read weight-at-age from. Specifically to get the
age-0 weight-at-age. This is typically \code{wtatage.ss_new}.}

\item{outfile}{A character string of the new file name to be created.
Must end in \code{.dat} or equal \code{wtatage.ss}.}

\item{dat_list}{An SS data list object as read in from
\code{\link[r4ss]{SS_readdat}} in the \pkg{r4ss} package. Make sure
you select option \code{section=2}.}

\item{ctl_file_in}{A path to the control file, outputed from an OM, containing
the OM parameters for growth and weight/length relationship. These values
are used to determine the uncertainty about weight for fish sampled in each
age bin. Commonly \code{control.ss_new}}

\item{years}{*A list the same length as \code{fleets} giving the years as
numeric vectors. If no fleet collected samples, keep the value to
\code{years=NULL}.}

\item{fill_fnc}{*A function to fill in missing values (ages and years). The
resulting weight-at-age file will have values for all years and ages.One
function is \code{fill_across}.}

\item{write_file}{A logical switch for whether to write \code{outfile} to
disk. Can be turned off to speed up testing or exploration of the
function. The new data are returned invisibly, as in the examples
below.}

\item{fleets}{*A numeric vector giving the fleets to be used. This order also
pertains to other arguments. A missing value excludes that fleet from
\code{outfile} (i.e. it turns it off so no samples are written). If none of
the fleet collected samples, keep the value to \code{fleets=NULL}.}

\item{cv_wtatage}{A user specified CV for growth. Default is \code{NULL}.}
}
\value{
A modified \code{.wtatage.ss} file if \code{write_file = TRUE}. A list
  object containing the modified \code{.wtatage.ss} file is returned invisibly.
}
\description{
Take a \code{data.SS_new} file containing expected values and sample from
true ages to get realistic proportions for the number of fish in each age
bin, then use the mean size-at-age and CV for growth to generate random
samples of size, which are then converted to weight and averaged to get mean
weight-at-age values. Missing ages and years are filled according to a
specified function. These matrices are then written to file for the EM. By
calling this function, \pkg{ss3sim} will turn on the empirical weight-at-age
function (set maturity option to 5) automatically. See
\code{\link{ss3sim_base}} for more details on how that is implemented.
If used with \code{\link{run_ss3sim}} the case file should be named
\code{wtatage}.
}
\section{Which arguments to specifiy in case files}{

All function argument descriptions that start with an asterisk (*) will be passed
through the case files to \code{\link{run_ss3sim}}. If one of these arguments
is not specified in a case file, then a value of \code{NULL} will be passed,
which may or may not be an appropriate value. Other arguments will be ignored
if specified.
}

\seealso{
\code{\link{fill_across}}

Other sampling functions: \code{\link{clean_data}},
  \code{\link{sample_agecomp}},
  \code{\link{sample_calcomp}}, \code{\link{sample_index}},
  \code{\link{sample_lcomp}}, \code{\link{sample_mlacomp}}
}
\author{
Cole Monnahan, Allan Hicks, Peter Kuriyama
}
