% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_rankings.R
\name{get_rankings}
\alias{get_rankings}
\title{Get the most recent PSA rankings from SquashInfo}
\usage{
get_rankings(top = NULL, category = NULL)
}
\arguments{
\item{top}{integer indicating the number of top PSA players by rank to return.}

\item{category}{character string indicating the competition category. Must be one of "both", "mens", or "womens".}
}
\value{
Tibble containing the player rank, previous month's rank, name, highest ranking achieved, date of highest ranking, nationality, and competition category.
}
\description{
Given a competition category, \code{get_rankings()} returns the most recent PSA rankings table.
}
\note{
This function only returns the most recent PSA rankings table for Men's and Women's singles competitions.
}
\examples{

## Get the top 10 ranked men's singles players
get_rankings(top = 10, category = "mens")

## Get the top 10 ranked women's singles players
\donttest{get_rankings(top = 20, category = "womens")}

## Get the top 20 players in both men's and women's singles competitions
\donttest{get_rankings(top = 20, category = "both")}

}
\references{
\url{http://www.squashinfo.com/rankings/men} \cr
    \url{http://www.squashinfo.com/rankings/women}
}
