\name{makecmap}
\alias{makecmap}
\title{ 
Generate a color map from numeric values to colors
 }
\description{
  Generate a color map from numeric values to a contiguous set of colors.

}
\usage{
makecmap(x, n = 10, breaks = pretty, 
  symm = FALSE, base = NA, 
  colFn = jet, col.na = NA, 
  right = FALSE, include.lowest = FALSE, ...)
}
\arguments{
  \item{x}{ A vector of numbers (only the finite range is used). }
  \item{n}{ Approximate number of color levels desired. }
  \item{breaks}{ A function to generate breakpoints, or the breakpoints themselves. }
  \item{symm}{ Extend the mapping domain to be symmetric around zero? }
  \item{base}{ Base for log scale, or NA to use a linear scale. }
  \item{colFn}{ A function that generates contiguous colors. }
  \item{col.na}{ Color to use for missing values. }
  \item{right}{ Logical; if TRUE, the intervals will be closed on the right (and open on the left). }
  \item{include.lowest}{ Logical, indicating if an \code{x[i]} equal to the lowest (or highest, for right = FALSE) \code{breaks} value should be included. }
  \item{\dots}{ Further arguments to \code{breaks}. }
}
\details{
  The general point of this function is to generate a mapping that can be used in combination with \code{\link{cmap}} to represent numeric data with colors in a consistent way.
  
  \code{colFn} should be a function that returns a vector of colors of specified length, such as \code{\link{rainbow}}, \code{\link{greyscale}}.  Custom functions of this type can be generated with \code{\link{colorRampPalette}}.
  
  The breakpoints can be specified explicitly, in which case \code{x} is ignored. Otherwise, the breakpoints are chosen to be nice, relatively round values (using \code{\link{pretty}}) covering the finite range of \code{x}.  Other functions such as \code{\link{prettyInt}} might also yield pleasing results.  However, if \code{diff(range(x)) == 0}, breakpoints are chosen to be \code{c(x, x + 1)} or \code{c(x - 1, x)} depending on \code{right}. 
  
  If \code{symm} is TRUE, the map domain is extended such that it is symmetric around zero. This can be useful when using divergent color palettes to ensure that the zero point is a neutral color.

  If \code{base} is specified, the breakpoints are generated using log-transformed data.
}
\value{
A list with the following components:
  \item{breaks }{ Breakpoints (numeric vector).}
  \item{colors }{ Colors (character or numeric vector). }
  \item{base }{ (as supplied in arguments) }
  \item{col.na }{ (as supplied in arguments) }
  \item{right  }{ (as supplied in arguments) }
  \item{include.lowest }{ (as supplied in arguments) }
}
\seealso{ 
  \code{\link{cmap}} and \code{\link{colorgram}} use the mappings generated by this function. 
  
  \code{\link{hkey}} plots a color key.
}
\examples{
  attach(iris)
  map <- makecmap(Petal.Length)
  myColors <- cmap(Petal.Length, map = map)
  plot(Sepal.Length, Sepal.Width, col = myColors, pch = 16)
  hkey(map, title = 'Petal.Length')
}
\keyword{ color }
