% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/genSample.MarginalNumericSpatial.R
\name{genSample.MarginalNumericSpatial}
\alias{genSample.MarginalNumericSpatial}
\title{Generating Monte Carlo sample from an uncertain object of a class 
'MarginalNumericSpatial'}
\usage{
\method{genSample}{MarginalNumericSpatial}(UMobject, n, samplemethod, p = 0,
  asList = TRUE, debug.level = 1, ...)
}
\arguments{
\item{UMobject}{uncertain object defined using defineUM().}

\item{n}{Integer. Number of Monte Carlo realizations.}

\item{samplemethod}{"ugs" for spatially correlated errors, "randomSampling" and
"stratifiedSampling" if no spatial correlation of errors is
considered.}

\item{p}{A vector of quantiles. Optional. Only required if sample method is
"stratifiedSampling" or "lhs".}

\item{asList}{logical. If asList = TRUE returns list of all samples as a list. 
If asList = FALSE returns samples in a format of distribution parameters in UMobject.}

\item{debug.level}{integer; set gstat internal debug level, see below for useful values. 
If set to -1 (or any negative value), a progress counter is printed.}

\item{...}{Additional parameters that may be passed, e.g. in
the "ugs" method. See examples.}
}
\value{
A Monte Carlo sample of uncertain input of a class of distribution
parameters.
}
\description{
Function that runs Monte Carlo simulations depending on the type of
uncertain object. Facilitates unconditional gausian simulation of errors for
spatially auto-correlated residulas, and random sampling, stratified
sampling if no spatial auto-correlation is included.
}
\details{
\strong{"ugs"} Unconditional gaussian simulation of spatially
auto-correlated errors.

\strong{"stratifiedSampling"} Number of samples (n) must be dividable by the
number of quantiles to assure each quantile is evenly represented.

\strong{"lhs"} Sampling method for at least two uncertain inputs. The
uncertain.object is then a list of two or more. It uses startified sampling
method to generate the inputs for the latin hypercude algorithm, hence the p
is restricted as above.
}
\examples{

set.seed(12345)
# load data
data(dem30m, dem30m_sd)

# "ugs" method example
dem_crm <- makecrm(acf0 = 0.78, range = 321, model = "Exp")
demUM <- defineUM(uncertain = TRUE, distribution = "norm", 
                   distr_param = c(dem30m, dem30m_sd), crm = dem_crm)
                   
# toy example
dem_sample <- genSample(UMobject = demUM, n = 2, samplemethod = "ugs", nmax = 6, asList = FALSE)
str(dem_sample)               
\dontrun{
dem_sample <- genSample(UMobject = demUM, n = 50, samplemethod = "ugs", nmax = 20, asList = FALSE)
str(dem_sample)
}


# "startifiedSampling" method example
demUM <- defineUM(uncertain = TRUE, distribution = "norm", distr_param = c(dem30m, dem30m_sd))
# toy example
dem_sample <- genSample(UMobject = demUM, n = 5, samplemethod = "stratifiedSampling", p = 0:5/5)
\dontrun{
dem_sample <- genSample(UMobject = demUM, n = 50, samplemethod = "stratifiedSampling", p = 0:5/5)
str(dem_sample)
}

# Examples with rasters
# (raster with auto-correlation)
data(OC, OC_sd)
OC_crm <- makecrm(acf0 = 0.6, range = 1000, model = "Sph")
OC_UM <- defineUM(TRUE, distribution = "norm", distr_param = c(OC, OC_sd), crm = OC_crm, id = "OC")
class(OC_UM)
# toy example
some_sample <- genSample(OC_UM, n = 3, "ugs", nmax=6)
some_sample
\dontrun{
some_sample <- genSample(OC_UM, n = 50, "ugs", nmax=20)
some_sample
}

}
\author{
Kasia Sawicka, Stefan van Dam, Gerard Heuvelink
}
