% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{AKmoose}
\alias{AKmoose}
\title{Data Set with Alaska Moose Counts.}
\format{
A SpatialPolygonsDataFrame object in the format of the (\code{sp}) package. The data frame \code{AKmoose@data} contains 860 rows and 4 columns:
\describe{
  \item{CENTRLAT}{The latitude of the centroid for each site}
  \item{CENTRLON}{The latitude of the centroid for each site}
  \item{STRAT}{A stratification variable}
  \item{TOTAL}{The total moose count on each site}
}
}
\source{
\href{http://www.adfg.alaska.gov/index.cfm?adfg=hunting.main}{Alaska Department of Fish and Game, Division of Wildlife Conservation} has released this data set under the CC0 (creative commons) license. To the extent possible under law, Alaska Department of Fish and Game, Division of Wildlife Conservation waives all copyright and related or neighboring rights to An Alaskan GSPE (Geospatial Population Estimator) Survey of Moose, AKmoose.rda. This work is published from: United States.
}
\usage{
AKmoose
}
\description{
A data set that can be used with the \code{sptotal} package. In
this example, the counts are of moose on 860 sites of equal area.
}
\examples{
data(AKmoose)
names(AKmoose@data)
summary(AKmoose@data)
}
\keyword{datasets}
