% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adjwgtNR.R
\name{adjwgtNR}
\alias{adjwgtNR}
\title{Adjust survey design weights for non-response by categories}
\usage{
adjwgtNR(wgt, MARClass, EvalStatus, TNRClass, TRClass)
}
\arguments{
\item{wgt}{vector of weights for each sample unit that will be adjusted
for non-response. Weights must be weights for the design as implemented.
All weights must be greater than zero.}

\item{MARClass}{vector that identifies for each sample unit the category
that will be used in non-response weight adjustment for sample units 
that are known to be target. Within each missing at random (MAR) 
category, the missing sample units that are not sampled are assumed to
be missing at random.}

\item{EvalStatus}{vector of the evaluation status for each sample unit.
Values must include the values given in TNRclass and TRClass. May 
include other values not required for the non-response adjustment.}

\item{TNRClass}{subset of values in EvalStatus that identify sample units
whose target status is known and that do not respond (i.e., are not 
sampled).}

\item{TRClass}{Subset of values in EvalStatus that identify sample units 
whose target status is known and that respond (i.e., are target and
sampled).}
}
\value{
Vector of sample unit weights that are adjusted for non-response
 and that is the same length of input weights. Weights for sample 
 units that did not response but were known to be eligible are set
 to zero. Weights for all other sample units are also set to zero.
}
\description{
Adjust weights for target sample units that do not respond 
and are missing at random within categories. The missing at random
assumption implies that their sample weight may be assigned to
specific categories of units that have responded (i.e., have been
sampled). This is a class-based method for non-response adjustment.
}
\examples{
set.seed(5)
wgt <- runif(40)
MARClass <- rep(c("A", "B"), rep(20, 2))
EvalStatus <- sample(c("Not_Target", "Target_Sampled", "Target_Not_Sampled"), 40, replace = TRUE)
TNRClass <- "Target_Not_Sampled"
TRClass <- "Target_Sampled"
adjwgtNR(wgt, MARClass, EvalStatus, TNRClass, TRClass)
# function that has an error check
}
\author{
Tony Olsen \email{olsen.tony@epa.gov}
}
\keyword{adjustment}
\keyword{non-response}
\keyword{survey}
\keyword{weight}
