% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cat.analysis.R
\name{cat.analysis}
\alias{cat.analysis}
\title{Categorical Data Analysis for Probability Survey Data}
\usage{
cat.analysis(sites = NULL, subpop = NULL, design = NULL,
  data.cat = NULL, popsize = NULL, popcorrect = FALSE,
  pcfsize = NULL, N.cluster = NULL, stage1size = NULL,
  sizeweight = FALSE, vartype = "Local", conf = 95,
  spsurvey.obj = NULL)
}
\arguments{
\item{sites}{Data frame consisting of two variables: the first variable
is site IDs, and the second variable is a logical vector indicating which
sites to use in the analysis.  If spsurvey.obj is not provided, then this
argument is required.  The default is NULL.}

\item{subpop}{Data frame describing sets of populations and
subpopulations for which estimates will be calculated.  The first variable
is site IDs.  Each subsequent variable identifies a Type of population,
where the variable name is used to identify Type.  A Type variable
identifies each site with one of the subpopulations of that Type.  If
spsurvey.obj is not provided, then this argument is required.  The default
is NULL.}

\item{design}{Data frame consisting of design variables.  If spsurvey.obj
is not provided, then this argument is required.  The default is NULL.
Variables should be named as follows:
  \describe{
    \item{siteID}{Vector of site IDs}
    \item{wgt}{Vector of weights, which are either the weights for a
      single-stage sample or the stage two weights for a two-stage sample}
    \item{xcoord}{Vector of x-coordinates for location, which are either
      the x-coordinates for a single-stage sample or the stage two
      x-coordinates for a two-stage sample}
    \item{ycoord}{Vector of y-coordinates for location, which are either
      the y-coordinates for a single-stage sample or the stage two
      y-coordinates for a two-stage sample}
    \item{stratum}{Vector of the stratum codes for each site}
    \item{cluster}{Vector of the stage one sampling unit (primary sampling
      unit or cluster) codes for each site}
    \item{wgt1}{Vector of stage one weights in a two-stage design}
    \item{xcoord1}{Vector of the stage one x-coordinates for location in a
      two-stage design}
    \item{ycoord1}{Vector of the stage one y-coordinates for location in a
      two-stage design}
    \item{support}{Vector of support values - for a finite resource, the
      value one (1) for a for site.  For an extensive resource, the measure
      of the sampling unit associated with a site.  Required for
      calculation of finite and continuous population 
      correction factors.}
    \item{swgt}{Vector of size-weights, which is the stage two size-weight
      for a two-stage design.}
    \item{swgt1}{Vector of stage one size-weights for a two-stage design.}
  }}

\item{data.cat}{Data frame of categorical response variables.  The first
variable is site IDs.  Subsequent variables are response variables. Missing
data (NA) is allowed.  If spsurvey.obj is not provided, then this argument
is required.  The default is NULL.}

\item{popsize}{Known size of the resource, which is used to perform ratio
adjustment to estimators expressed using measurement units for the resource
and to calculate strata proportions for calculating estimates for a
stratified sample.  For a finite resource, this argument is either the
total number of sampling units or the known sum of size-weights.  For an
extensive resource, this argument is the measure of the resource, i.e.,
either known total length for a linear resource or known total area for an
areal resource.  The argument must be in the form of a list containing an
element for each population Type in the subpop data frame, where NULL is a
valid choice for a population Type.  The list must be named using the
column names for the population Types in subpop. If a population Type
doesn't contain subpopulations, then each element of the list is either a
single value for an unstratified sample or a vector containing a value for
each stratum for a stratified sample, where elements of the vector are
named using the stratum codes.  If a population Type contains
subpopulations, then each element of the list is a list containing an
element for each subpopulation, where the list is named using the
subpopulation names.  The element for each subpopulation will be either a
single value for an unstratified sample or a named vector of values for a
stratified sample.  The default is NULL.\cr\cr
  Example popsize for a stratified sample:\cr
    popsize = list("Pop 1"=c("Stratum 1"=750,\cr
                             "Stratum 2"=500,\cr
                             "Stratum 3"=250),\cr
                   "Pop 2"=list("SubPop 1"=c("Stratum 1"=350,\cr
                                             "Stratum 2"=250,\cr
                                             "Stratum 3"=150),\cr
                                "SubPop 2"=c("Stratum 1"=250,\cr
                                             "Stratum 2"=150,\cr
                                             "Stratum 3"=100),\cr
                                "SubPop 3"=c("Stratum 1"=150,\cr
                                             "Stratum 2"=150,\cr
                                             "Stratum 3"=75)),\cr
                   "Pop 3"=NULL)\cr\cr
  Example popsize for an unstratified sample:\cr
    popsize = list("Pop 1"=1500,\cr
                   "Pop 2"=list("SubPop 1"=750,\cr
                                "SubPop 2"=500,\cr
                                "SubPop 3"=375),\cr
                   "Pop 3"=NULL)\cr}

\item{popcorrect}{Logical value that indicates whether finite or continuous
population correction factors should be employed during variance
estimation, where TRUE = use the correction factor and FALSE = do not use
the correction factor.  The default is FALSE.  To employ the correction
factor for a single-stage sample, values must be supplied for argument
pcfsize and for the support variable of the design argument.  To employ the
correction factor for a two-stage sample, values must be supplied for
arguments N.cluster and stage1size, and for the support variable of the
design argument.}

\item{pcfsize}{Size of the resource, which is required for calculation of
finite and continuous population correction factors for a single-stage
sample. For a stratified sample this argument must be a vector containing a
value for each stratum and must have the names attribute set to identify
the stratum codes.  The default is NULL.}

\item{N.cluster}{Number of stage one sampling units in the resource, which
is required for calculation of finite and continuous population correction
factors for a two-stage sample.  For a stratified sample this argument must
be a vector containing a value for each stratum and must have the names
attribute set to identify the stratum codes.  The default is NULL.}

\item{stage1size}{Size of the stage one sampling units of a two-stage
sample, which is required for calculation of finite and continuous
population correction factors for a two-stage sample and must have the
names attribute set to identify the stage one sampling unit codes.  For a
stratified sample, the names attribute must be set to identify both stratum
codes and stage one sampling unit codes using a convention where the two
codes are separated by the & symbol, e.g., "Stratum 1&Cluster 1". The
default is NULL.}

\item{sizeweight}{Logical value that indicates whether size-weights should
be used in the analysis, where TRUE = use the size-weights and FALSE = do
not use the size-weights.  The default is FALSE.}

\item{vartype}{The choice of variance estimator, where "Local" = local mean
estimator and "SRS" = SRS estimator.  The default is "Local".}

\item{conf}{Numeric value for the confidence level.  The default is 95.}

\item{spsurvey.obj}{List of class spsurvey.analysis that was produced by
the function spsurvey.analysis.  Depending on input to that function, some
elements of the list may be NULL.  The default is NULL.}
}
\value{
A data frame of population estimates for all combinations of
  population Types, subpopulations within Types, response variables, and
  categories within each response variable.  Estimates are provided for
  proportion and size of the population plus standard error and confidence
  interval estimates.
}
\description{
This function organizes input and output for analysis of categorical data
generated by a probability survey.  Input can be either an object of class
spsurvey.analysis (see the documentation for function spsurvey.analysis)
or through use of the other arguments to this function.
}
\section{Other Functions Required}{

  \describe{
    \item{\code{\link{dframe.check}}}{check site IDs, the sites data frame,
      the subpop data frame, and the data.cat data frame to assure valid
      contents and, as necessary, create the sites data frame and the subpop
      data frame}
    \item{\code{\link{vecprint}}}{takes an input vector and outputs a
      character string with line breaks inserted}
    \item{\code{\link{uniqueID}}}{creates unique site IDs by appending a
      unique number to each occurrence of a site ID}
    \item{\code{\link{input.check}}}{check input values for errors,
      consistency, and compatibility with analytical functions}
    \item{\code{\link{category.est}}}{estimate proportion (expressed as
      percent) and size of a resource in each of a set of categories}
  }
}

\examples{
# Categorical variable example for two resource classes:
mysiteID <- paste("Site", 1:100, sep="")
mysites <- data.frame(
  siteID=mysiteID,
  Active=rep(TRUE, 100))
mysubpop <- data.frame(
  siteID=mysiteID,
  All.Sites=rep("All Sites", 100),
  Resource.Class=rep(c("Good","Poor"), c(55,45)))
mydesign <- data.frame(
  siteID=mysiteID,
  wgt=runif(100, 10, 100),
  xcoord=runif(100),
  ycoord=runif(100),
  stratum=rep(c("Stratum1", "Stratum2"), 50))
mydata.cat <- data.frame(
  siteID=mysiteID,
  CatVar=rep(c("north", "south", "east", "west"), 25))
mypopsize <- list(
  All.Sites=c(Stratum1=3500, Stratum2=2000),
  Resource.Class=list(Good=c(Stratum1=2500, Stratum2=1500),
                      Poor=c(Stratum1=1000, Stratum2=500)))
cat.analysis(sites=mysites, subpop=mysubpop, design=mydesign,
  data.cat=mydata.cat, popsize=mypopsize)

# Exclude category "south" from the analysis:
mysites <- data.frame(
  siteID=mysiteID,
  Active=rep(c(TRUE, FALSE, TRUE, TRUE), 25))
cat.analysis(sites=mysites, subpop=mysubpop, design=mydesign,
  data.cat=mydata.cat, popsize=mypopsize)

}
\references{
Diaz-Ramos, S., D.L. Stevens, Jr., and A.R. Olsen. (1996). \emph{EMAP
  Statistical Methods Manual.} EPA/620/R-96/XXX.  Corvallis, OR: U.S.
  Environmental Protection Agency, Office of Research and Development,
  National Health Effects and Environmental Research Laboratory, Western
  Ecology Division.
}
\seealso{
\code{\link{category.est}}
}
\author{
Tony Olsen \email{Olsen.Tony@epa.gov}\cr
  Tom Kincaid \email{Kincaid.Tom@epa.gov}
}
\keyword{survey}
\keyword{univar}
