% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grtslin.R
\name{grtslin}
\alias{grtslin}
\title{Select a Generalized Random-Tesselation Stratified (GRTS) Sample of a Linear Resource}
\usage{
grtslin(shapefilename = NULL, linframe, samplesize = 100,
  SiteBegin = 1, shift.grid = TRUE, startlev = NULL, maxlev = 1)
}
\arguments{
\item{shapefilename}{Name of the input shapefile.  If shapefilename equals
NULL, then the shapefile or shapefiles in the working directory are used.
The default is NULL.}

\item{linframe}{Data frame containing id, mdcaty, and mdm.}

\item{samplesize}{Number of points to select in the sample.  The default is
100.}

\item{SiteBegin}{First number to start siteID numbering.  The default is 1.}

\item{shift.grid}{Option to randomly shift the hierarchical grid.  The
default is TRUE.}

\item{startlev}{Initial number of hierarchical levels to use for the GRTS
grid, which must be less than or equal to maxlev (if maxlev is specified)
and cannot be greater than 11.  The default is NULL.}

\item{maxlev}{Maximum number of hierarchical levels to use for the GRTS
grid, which cannot be greater than 11.  The default is 11.}
}
\value{
Data frame of sample points containing: siteID, id, x, y, mdcaty,
  and weight.
}
\description{
This function select a GRTS sample of a linear resource.  The function uses
hierarchical randomization to ensure that the sample will include no more
than one point per cell and then picks a point in selected cells.
}
\section{Other Functions Required}{

  \describe{
    \item{\code{numLevels}}{C function to determine the number of
      levels for hierarchical randomization}
    \item{\code{constructAddr}}{C function to construct the
      hierarchical address for all points}
    \item{\code{ranho}}{C function to construct the randomized
      hierarchical address for all points}
    \item{\code{pickGridCells}}{C function to select grid cells that
      get a sample point}
    \item{\code{insideLinearGridCell}}{C function to determine ID
      value and clipped polyline length for shapefile records contained in
      the selected grid cells}
    \item{\code{\link{selectrecordID}}}{select a shapefile record from which
      to select a sample point}
    \item{\code{pickLinearSamplePoints}}{C function to pick sample
      points in the selected grid cells}
  }
}

\author{
Tony Olsen \email{Olsen.Tony@epa.gov}
}
\keyword{survey}
