% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bs_components.R
\name{bsAlert}
\alias{bsAlert}
\title{Bootstrap3 alert}
\usage{
bsAlert(..., status = "success", closeable = TRUE)
}
\arguments{
\item{...}{any shiny tag or tagList you want to add to the alert body, \strong{or}
any additional attributes you want to add to the alert element.}

\item{status}{string, one of "success", "info", "warning", "danger"}

\item{closeable}{bool, can the alert be closed?}
}
\value{
shiny tag element
}
\description{
Add a Bootstrap3 alert component to the UI
}
\details{
Read more here: https://getbootstrap.com/docs/3.3/components/#alerts
}
\examples{
if(interactive()) {
  library(shiny)
  ui <- fluidPage(
    bsAlert(tags$b("Success: "), "You made it", status = "success"),
    bsAlert(tags$b("Info: "), "Something happened", status = "info"),
    bsAlert(tags$b("Warning: "), "Something is not right", status = "warning"),
    bsAlert(tags$b("Danger: "), "Oh no...", status = "danger")
  )
  server <- function(input, output, session) {}
  shinyApp(ui, server)
}
}
