% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_post.R
\name{drop_realization}
\alias{drop_realization}
\title{Drop MCMC realizations}
\usage{
drop_realization(fit, drop = 0.1 * fit$L)
}
\arguments{
\item{fit}{Object of class \code{damcmc_res} or \code{bdmcmc_res}.}

\item{drop}{If one integer is provided, the function will drop the first 1:drop
realizations. If an integer vector is provided, it will drop these
iterations. If a logical vector is provided (with the same length as the chain
length of \code{fit}), it will be used for subsetting directly.}
}
\description{
The function drops realizations from a DAMCMC or BDMCMC fit and
returns the resulting fit object.

For examples see

\url{http://faculty.missouri.edu/~micheasa/sppmix/sppmix_all_examples.html
#drop_realization}
}
\examples{
\donttest{
fit <- est_mix_bdmcmc(spatstat::redwood, m = 5)
fit
drop_realization(fit, 500)
drop_realization(fit, fit$numcomp != 5)}

}
\seealso{
\code{\link{est_mix_bdmcmc}}
}
\author{
Sakis Micheas, Yuchen Wang
}
