% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/normmix.R
\docType{data}
\name{demo_mix}
\alias{demo_mix}
\alias{demo_intsurf}
\alias{demo_genPPP}
\alias{demo_truemix3}
\alias{demo_truemix3comp}
\alias{demo_truesurf3}
\alias{demo_intsurf3comp}
\title{Demo objects}
\format{An object of class \code{normmix} of length 5.}
\usage{
demo_mix

demo_intsurf

demo_genPPP

demo_truemix3

demo_truemix3comp

demo_truesurf3

demo_intsurf3comp
}
\description{
Demo objects (mixture, surface and generated pattern)
using the classes provided by the \code{\link{sppmix}} package.

For examples see

\url{http://faculty.missouri.edu/~micheasa/sppmix/sppmix_all_examples.html
#demo_mix}
}
\examples{
\donttest{
demo_mix <- normmix(ps = c(.3, .7), mus = list(c(0.2, 0.2), c(.8, .8)),
 sigmas = list(.01*diag(2), .01*diag(2)))
demo_intsurf <- normmix(ps = c(.3, .7), mus = list(c(0.2, 0.2),
 c(.8, .8)),sigmas = list(.01*diag(2), .01*diag(2)), lambda = 100,
 win = spatstat::square(1))
demo_genPPP<-rsppmix(demo_truesurf3, truncate=FALSE)}

}
\author{
Jiaxun Chen, Sakis Micheas, Yuchen Wang
}
\keyword{datasets}
