% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/est_mix_intensity.R
\name{Get_Rdiag}
\alias{Get_Rdiag}
\title{Checking convergence: diagnostics}
\usage{
Get_Rdiag(pp, m, truncate = FALSE, L = 20000, numofchains = 2,
  permute = 0)
}
\arguments{
\item{pp}{Point pattern object of class \code{\link[spatstat]{ppp}}.}

\item{m}{The number of components to fit.}

\item{truncate}{Logical variable indicating whether or not we
normalize the densities of the mixture components
to have all their mass within the window defined
in the point pattern \code{pp}.}

\item{L}{Number of iterations to use for
each chain created; default is 20000. Note
that half of them will be dropped so use a large number.}

\item{numofchains}{Number of chains to create; default is 2.}

\item{permute}{Request to generate chains that are
unpermuted (\code{permute=0}), identifiability
constraint (IC) permuted (\code{permute=1}), or minimum squared
error loss (SEL) permuted (\code{permute=2}).}
}
\description{
This function reports the Gelman-Rubin
convergence diagnostic \code{R} (also known as
the potential scale reduction), by producing
\code{k} DAMCMC fits and computing the
within-chain and between-chain variances. Values approximately
equal to 1 indicate convergence, otherwise we need to run the chain for
a longer number of iterations to get convergence.

For DAMCMC examples see

\url{http://faculty.missouri.edu/~micheasa/sppmix/sppmix_all_examples.html
#Get_Rdiag}
}
\examples{
\donttest{
truemix_surf <- rmixsurf(m = 3, lambda=100, xlim = c(-3,3), ylim = c(-3,3))
plot(truemix_surf)
genPPP=rsppmix(intsurf = truemix_surf, truncate = FALSE)
Get_Rdiag(pp = genPPP, m = 3)}

}
\seealso{
\code{\link{est_mix_damcmc}},
\code{\link{rmixsurf}},
\code{\link{rsppmix}}
}
\author{
Sakis Micheas
}
