% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_post.R
\name{GetIPPPLikValue}
\alias{GetIPPPLikValue}
\title{Retrieve the IPPP likelihood value}
\usage{
GetIPPPLikValue(pp, surf, truncate = FALSE)
}
\arguments{
\item{pp}{Point pattern object of class \code{ppp}.}

\item{surf}{IPPP intensity surface object of class \code{intensity_surface}.}

\item{truncate}{Logical variable indicating whether or not we
normalize the densities of the mixture components
to have all their mass within the window defined
in the point pattern \code{pp}.}
}
\description{
Given a point pattern this function
calculates the IPPP likelihood value.

For examples see

\url{http://faculty.missouri.edu/~micheasa/sppmix/sppmix_all_examples.html
#GetIPPPLikValue}
}
\examples{
\donttest{
truemix_surf <- rmixsurf(m = 3, lambda=100,xlim = c(-3,3),ylim = c(-3,3))
plot(truemix_surf,main="True IPPP intensity surface")
genPPP=rsppmix(intsurf = truemix_surf, truncate = FALSE)
fit <- est_mix_damcmc(genPPP, m = 3)
MAPest=GetMAPEst(fit)
GetIPPPLikValue(genPPP,MAPest)
GetIPPPLikValue(genPPP,GetPMEst(fit))}

}
\seealso{
\code{\link{est_mix_damcmc}},
\code{\link{rmixsurf}},
\code{\link{rsppmix}},
\code{\link{GetPMEst}}
}
\author{
Sakis Micheas
}
