% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary_post.R
\name{summary.damcmc_res}
\alias{summary.damcmc_res}
\title{Summarize DAMCMC results}
\usage{
\method{summary}{damcmc_res}(object, burnin = object$L/10, alpha = 0.05,
  dgt = 4, ...)
}
\arguments{
\item{object}{Object of class \code{damcmc_res}.}

\item{burnin}{Number of initial
realizations to discard. By default, it
is 1/10 of the total number of iterations.}

\item{alpha}{Level alpha for the credible
sets. Default is 0.05, for 95% credible
sets of the mixture parameters.}

\item{dgt}{Number of digits to use
(formatting the output).}

\item{...}{Additional arguments for the S3 method.}
}
\description{
Prints a brief summary of the results of a DAMCMC fit.

For examples see

\url{http://www.stat.missouri.edu/~amicheas/sppmix/sppmix_all_examples.html
#summary.damcmc_res}
}
\examples{

\dontrun{
# generate data
truemix<- rnormmix(m = 3, sig0 = .1, df = 5, xlim= c(0, 5), ylim = c(0, 5))
summary(truemix)
intsurf=to_int_surf(truemix, lambda = 100, win =spatstat::owin( c(0, 5),c(0, 5)))
pp1 = rsppmix(intsurf = intsurf)# draw points
#Run DAMCMC and get posterior realizations
postfit=est_mix_damcmc(pp1,m=3)
#summary of the posterior results
summary(postfit)}

}
\author{
Jiaxun Chen, Sakis Micheas, Yuchen Wang
}
\seealso{
\code{\link{rnormmix}},
\code{\link{to_int_surf}},
\code{\link{rsppmix}},
\code{\link{est_mix_damcmc}},
\code{\link[spatstat]{owin}}
}

