% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sport-hockey.R
\name{geom_hockey}
\alias{geom_hockey}
\title{Generate a ggplot2 instance containing an ice rink for a specified league}
\usage{
geom_hockey(
  league,
  full_surf = TRUE,
  rotate = FALSE,
  rotation_dir = "ccw",
  ...
)
}
\arguments{
\item{league}{The league for which to draw the surface}

\item{full_surf}{A boolean indicating whether or not to plot a full surface
represenation of the surface. Default: \code{TRUE}}

\item{rotate}{A boolean indicating whether or not the final rink plot needs
to be rotated. Default: \code{FALSE}}

\item{rotation_dir}{A string indicating which direction to rotate the final
rink plot Default: \code{'ccw'}}

\item{...}{Additional arguments to pass to the function. These should be the
colors to pass to the \code{{league}_features_set_colors()} function,
(although the colors are defined in the rule book) or units with which to
draw the plot}
}
\value{
A ggplot2 instance with a full-surface representation of an ice
hockey rink
}
\description{
Generate a ggplot2 instance containing an ice rink for a specified league
}
\examples{
geom_hockey(league = "NHL")
geom_hockey(league = "IIHF", full_surf = FALSE)
geom_hockey(league = "NCAA", rotate = TRUE, rotation_dir = "ccw")
}
