% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sport-soccer.R
\name{geom_soccer}
\alias{geom_soccer}
\title{Generate a ggplot2 instance containing a soccer pitch for a specified league}
\usage{
geom_soccer(
  league,
  touchline_length = 120,
  goal_line_length = 90,
  full_surf = TRUE,
  rotate = FALSE,
  rotation_dir = "ccw",
  ...
)
}
\arguments{
\item{league}{The league for which to draw the surface}

\item{touchline_length}{The length of the touchline. This should be the
entire length (both halves) of the pitch. Default: \code{120}}

\item{goal_line_length}{The length of the goal line. Default: \code{90}}

\item{full_surf}{A boolean indicating whether or not to plot a full surface
representation of the surface. Default: \code{TRUE}}

\item{rotate}{A boolean indicating whether or not this feature needs to be
rotated. Default: \code{FALSE}}

\item{rotation_dir}{A string indicating which direction to rotate the
feature. Default: \code{'ccw'}}

\item{...}{Additional arguments to pass to the function. These should be the
colors to pass to the \code{mlb_features_set_colors()} function, or units
with which to draw the plot}
}
\value{
A ggplot2 instance with a full-surface representation of a soccer
pitch
}
\description{
Generate a ggplot2 instance containing a soccer pitch for a specified league
}
\examples{
geom_soccer(league = "MLS")
geom_soccer(league = "PREMIER", rotate = TRUE, rotation_dir = "ccw")
}
