test_that("spcov_initial works", {
  spcov_initial_val <- spcov_initial("exponential", de = 1, range = 0.4)
  expect_equal(length(spcov_initial_val), 2)
  expect_equal(unname(spcov_initial_val$initial), c(1, 0.4))
  expect_equal(unname(spcov_initial_val$is_known), c(FALSE, FALSE))

  spcov_initial_val <- spcov_initial("exponential", de = 1, range = 0.4, known = "de")
  expect_equal(length(spcov_initial_val), 2)
  expect_equal(unname(spcov_initial_val$initial), c(1, 0.4))
  expect_equal(unname(spcov_initial_val$is_known), c(TRUE, FALSE))

  spcov_initial_val <- spcov_initial("exponential", de = 1, range = 0.4, known = "given")
  expect_equal(length(spcov_initial_val), 2)
  expect_equal(unname(spcov_initial_val$initial), c(1, 0.4))
  expect_equal(unname(spcov_initial_val$is_known), c(TRUE, TRUE))

  spcov_initial_val <- spcov_initial("exponential", de = 1, range = 0.4, known = "xyz")
  expect_equal(length(spcov_initial_val), 2)
  expect_equal(unname(spcov_initial_val$initial), c(1, 0.4))
  expect_equal(unname(spcov_initial_val$is_known), c(FALSE, FALSE))
})

test_that("names of spcov_initial work", {
  spcov_initial1 <- spcov_initial("matern", de = 1, ie = 1, range = 1, extra = 1, rotate = 1, scale = 1)
  spcov_initial2 <- spcov_initial("matern", de = c(a = 1), ie = c(a = 1), range = c(a = 1), extra = c(a = 1), rotate = c(a = 1), scale = c(a = 1))
  expect_equal(spcov_initial1, spcov_initial2)
})


test_that("spcov_initial works", {
  expect_error(spcov_initial("exponential"), NA)
  expect_error(spcov_initial("spherical"), NA)
  expect_error(spcov_initial("gaussian"), NA)
  expect_error(spcov_initial("triangular"), NA)
  expect_error(spcov_initial("circular"), NA)
  expect_error(spcov_initial("cubic"), NA)
  expect_error(spcov_initial("pentaspherical"), NA)
  expect_error(spcov_initial("cosine"), NA)
  expect_error(spcov_initial("wave"), NA)
  expect_error(spcov_initial("jbessel"), NA)
  expect_error(spcov_initial("gravity"), NA)
  expect_error(spcov_initial("rquad"), NA)
  expect_error(spcov_initial("magnetic"), NA)
  expect_error(spcov_initial("matern"), NA)
  expect_error(spcov_initial("cauchy"), NA)
  expect_error(spcov_initial("pexponential"), NA)
  expect_error(spcov_initial("car"), NA)
  expect_error(spcov_initial("sar"), NA)
  expect_error(spcov_initial("none"), NA)
})

test_that("errors return", {
  expect_error(spcov_initial("matern", de = NA), NA)
  expect_error(spcov_initial("matern", ie = NA), NA)
  expect_error(spcov_initial("matern", range = NA), NA)
  expect_error(spcov_initial("matern", extra = NA), NA)
  expect_error(spcov_initial("matern", rotate = NA), NA)
  expect_error(spcov_initial("matern", scale = NA), NA)

  expect_error(spcov_initial("matern", de = NA, known = "given"))
  expect_error(spcov_initial("matern", ie = NA, known = "given"))
  expect_error(spcov_initial("matern", range = NA, known = "given"))
  expect_error(spcov_initial("matern", extra = NA, known = "given"))
  expect_error(spcov_initial("matern", rotate = NA, known = "given"))
  expect_error(spcov_initial("matern", scale = NA, known = "given"))
  expect_error(spcov_initial("matern", de = 1, scale = NA, known = "given"))
  expect_error(spcov_initial("matern", de = 1, scale = NA, known = "de"), NA)
  expect_error(spcov_initial("car", de = NA, known = "given"))
  expect_error(spcov_initial("sar", ie = NA, known = "given"))
  expect_error(spcov_initial("car", range = NA, known = "given"))
  expect_error(spcov_initial("sar", extra = NA, known = "given"))
  expect_error(spcov_initial("sar", de = 1, extra = NA, known = "given"))
  expect_error(spcov_initial("sar", de = 1, extra = NA, known = "de"), NA)

  # spcov params checks
  expect_error(spcov_initial("exponential", de = -1, ie = 1, range = 1))
  expect_error(spcov_initial("exponential", de = 1, ie = -1, range = 1))
  expect_error(spcov_initial("exponential", de = 1, ie = -1, range = -1))
  expect_error(spcov_initial("exponential", de = 1, ie = 1, range = 1, rotate = 10))
  expect_error(spcov_initial("exponential", de = 1, ie = 1, range = 1, rotate = 1, scale = 2))
  expect_error(spcov_initial("exponential", de = 1, ie = 1, range = 1, rotate = -10))
  expect_error(spcov_initial("exponential", de = 1, ie = 1, range = 1, rotate = 1, scale = -2))
  expect_error(spcov_initial("matern", de = 1, ie = -1, range = 1, extra = -1))
  expect_error(spcov_initial("matern", de = 1, ie = -1, range = 1, extra = 1 / 6))
  expect_error(spcov_initial("matern", de = 1, ie = -1, range = 1, extra = 6))
  expect_error(spcov_initial("cauchy", de = 1, ie = 1, range = 1, extra = -5))
  expect_error(spcov_initial("cauchy", de = 1, ie = 1, range = 1, extra = 0))
  expect_error(spcov_initial("pexponential", de = 1, ie = 1, range = 1, extra = 3))
  expect_error(spcov_initial("pexponential", de = 1, ie = 1, range = 1, extra = 0))
  expect_error(spcov_initial("pexponential", de = 1, ie = 1, range = 1, extra = -3))

  # spcov type problems
  expect_error(spcov_initial(de = 1, ie = 1, range = 1))
  expect_error(spcov_initial("xyz", de = 1, ie = 1, range = 1))
})
