% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rvi.R
\name{rvi}
\alias{rvi}
\title{Relative variable influence based on generalized boosted regression
modeling (gbm)}
\usage{
rvi(trainx, trainy, var.monotone = rep(0, ncol(trainx)),
  family = "gaussian", n.trees = 3000, learning.rate = 0.001,
  interaction.depth = 2, bag.fraction = 0.5, train.fraction = 1,
  n.minobsinnode = 10, cv.fold = 10, weights = rep(1, nrow(trainx)),
  keep.data = FALSE, verbose = TRUE, n.cores = 6, ...)
}
\arguments{
\item{trainx}{a dataframe or matrix contains columns of predictive variables.}

\item{trainy}{a vector of response, must have length equal to the number of
rows in trainx.}

\item{var.monotone}{an optional vector, the same length as the number of
predictors, indicating which variables have a monotone increasing (+1),
decreasing (-1), or arbitrary (0) relationship with the outcome. By default,
a vector of 0 is used.}

\item{family}{either a character string specifying the name of the distribution to
use or a list with a component name specifying the distribution and any
additional parameters needed. See gbm for details. By default, "gaussian" is
used.}

\item{n.trees}{the total number of trees to fit. This is equivalent to the
number of iterations and the number of basis functions in the additive
expansion. By default, 3000 is used.}

\item{learning.rate}{a shrinkage parameter applied to each tree in the
expansion. Also known as step-size reduction.}

\item{interaction.depth}{the maximum depth of variable interactions.
1 implies an additive model, 2 implies a model with up to 2-way
interactions, etc. By default, 2 is used.}

\item{bag.fraction}{the fraction of the training set observations randomly
selected to propose the next tree in the expansion. By default, 0.5 is used.}

\item{train.fraction}{The first train.fraction * nrows(data) observations
are used to fit the gbm and the remainder are used for computing
out-of-sample estimates of the loss function.}

\item{n.minobsinnode}{minimum number of observations in the trees terminal
nodes. Note that this is the actual number of observations not the total
weight. By default, 10 is used.}

\item{cv.fold}{integer; number of cross-validation folds to perform within
gbm. if > 1, then apply n-fold cross validation; the default is 10, i.e.,
10-fold cross validation that is recommended.}

\item{weights}{an optional vector of weights to be used in the fitting
process. Must be positive but do not need to be normalized.
If keep.data = FALSE in the initial call to gbm then it is the user's
responsibility to resupply the weights to gbm.more. By default, a vector of
1 is used.}

\item{keep.data}{a logical variable indicating whether to keep the data and
an index of the data stored with the object. Keeping the data and index
makes subsequent calls to gbm.more faster at the cost of storing an extra
copy of the dataset. By default, 'FALSE' is used.}

\item{verbose}{If TRUE, gbm will print out progress and performance
indicators. By default, 'TRUE' is used.}

\item{n.cores}{The number of CPU cores to use. See gbm for details. By
default, 6 is used.}

\item{...}{other arguments passed on to gbm.}
}
\value{
A list of column number of importance variable in trainx arranged from the most
influential to the least influential (impvar), and a dataframe of variables (var), and
relative influence (rel.inf)
}
\description{
This function is to to derive a relative variable influence based
on generalized boosted regression modeling.
}
\note{
This function is largely based on gbm.
}
\examples{
\dontrun{
data(sponge)
set.seed(1234)
rvi1 <- rvi(sponge[, -c(3)], sponge[, 3], family = "poisson", n.cores=2)
names(ri1)
impvar <- (1:ncol(sponge[, -c(3)]))[ri1$var]
}

}
\references{
Greg Ridgeway with contributions from others (2015). gbm:
Generalized Boosted Regression Models. R package version 2.1.1.
https://CRAN.R-project.org/package=gbm
}
\author{
Jin Li
}
