% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/splitting.R
\name{split_stratum}
\alias{split_stratum}
\title{Split a stratum into two parts}
\usage{
split_stratum(stratum, ...)
}
\arguments{
\item{stratum}{(data frame, tibble, list, or vector) Stratum to split;
dataframes and tibbles are counted and split by row. All other data types
are counted and split by element}

\item{...}{
  Arguments passed on to \code{\link[=get_split_indexes_from_stratum]{get_split_indexes_from_stratum}}
  \describe{
    \item{\code{method}}{(character) Splitting method. Note that \code{first_second} and
\code{odd_even} splitting method will only deliver a valid split with
default settings for other arguments (\code{subsample_p = 1, split_p = 1,
replace = TRUE})}
    \item{\code{replace}}{(logical) If FALSE, splits are constructed by sampling from
stratum without replacement. If TRUE, stratum is sampled with replacement.}
    \item{\code{split_p}}{(numeric) Desired joint size of both parts, expressed as a
proportion of the size of the subsampled \code{stratum}. If \code{split_p}
is larger than 1, and \code{careful} is FALSE, then parts are automatically
sampled with replacement}
    \item{\code{subsample_p}}{(numeric) Subsample a proportion of \code{stratum} to be
used in the split.}
    \item{\code{careful}}{(boolean) If TRUE, stop with an error when called with
arguments that may yield unexpected splits}
  }}
}
\value{
(list) List with two elements that contain each of the two parts of
  stratum split in two.
}
\description{
Splits \code{stratum} into two parts. For more information
about splitting options, and an extensive list of examples, see
\code{\link{get_split_indexes_from_stratum}}.
}
\examples{
# Split stratum odd-even
ds <- data.frame(condition = rep(c("a", "b"), each = 4), score = 1 : 8)
split_stratum(ds, method = "odd_even")
}
\seealso{
Other splitting functions: 
\code{\link{apply_split_indexes_to_strata}()},
\code{\link{apply_split_indexes_to_stratum}()},
\code{\link{check_strata}()},
\code{\link{get_split_indexes_from_strata}()},
\code{\link{get_split_indexes_from_stratum}()},
\code{\link{split_df}()},
\code{\link{split_strata}()},
\code{\link{stratify}()}
}
\concept{splitting functions}
