% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/forest_helpers.R
\name{pruneForest}
\alias{pruneForest}
\title{Prune each tree in forest using a given complexity parameter.}
\usage{
pruneForest(forest, cp)
}
\arguments{
\item{forest}{A spline forest object}

\item{cp}{The complexity parameter that will be used to prune each tree (see rpart package documentation for detailed description of complexity parameter)}
}
\value{
A new splineforest object where each tree has been pruned to the desired level.
}
\description{
Prunes each tree in the list forest$Trees according to the provided complexity parameter. Returns a new forest.
}
\examples{
print(avSize(forest))
print(avSize(pruneForest(forest, cp=0.007)))
print(avSize(pruneForest(forest, cp=0.01)))
}
