/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.themes;

import bibliothek.gui.DockController;
import bibliothek.gui.DockStation;
import bibliothek.gui.DockTheme;
import bibliothek.gui.dock.StackDockStation;
import bibliothek.gui.dock.dockable.DockableMovingImageFactory;
import bibliothek.gui.dock.event.UIListener;
import bibliothek.gui.dock.focus.DockableSelection;
import bibliothek.gui.dock.station.Combiner;
import bibliothek.gui.dock.station.DisplayerFactory;
import bibliothek.gui.dock.station.StationPaint;
import bibliothek.gui.dock.station.stack.StackDockComponent;
import bibliothek.gui.dock.station.stack.StackDockComponentFactory;
import bibliothek.gui.dock.station.stack.StackDockComponentParent;
import bibliothek.gui.dock.station.stack.tab.layouting.TabPlacement;
import bibliothek.gui.dock.themes.ColorScheme;
import bibliothek.gui.dock.themes.DockThemeExtension;
import bibliothek.gui.dock.themes.ThemeProperties;
import bibliothek.gui.dock.themes.basic.BasicColorScheme;
import bibliothek.gui.dock.themes.basic.BasicCombiner;
import bibliothek.gui.dock.themes.basic.BasicDisplayerFactory;
import bibliothek.gui.dock.themes.basic.BasicDockTitleFactory;
import bibliothek.gui.dock.themes.basic.BasicDockableSelection;
import bibliothek.gui.dock.themes.basic.BasicMovingImageFactory;
import bibliothek.gui.dock.themes.basic.BasicStackDockComponent;
import bibliothek.gui.dock.themes.basic.BasicStationPaint;
import bibliothek.gui.dock.themes.color.ExtendingColorScheme;
import bibliothek.gui.dock.title.DockTitleFactory;
import bibliothek.gui.dock.util.DockProperties;
import bibliothek.gui.dock.util.NullPriorityValue;
import bibliothek.gui.dock.util.Priority;
import bibliothek.gui.dock.util.PropertyKey;
import bibliothek.gui.dock.util.PropertyValue;
import bibliothek.gui.dock.util.property.DynamicPropertyFactory;
import javax.swing.SwingUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThemeProperties(nameBundle="theme.basic", descriptionBundle="theme.basic.description", authors={"Benjamin Sigg"}, webpages={})
public class BasicTheme
implements DockTheme {
    private NullPriorityValue<Combiner> combiner = new NullPriorityValue();
    private NullPriorityValue<StationPaint> paint = new NullPriorityValue();
    private NullPriorityValue<DisplayerFactory> displayerFactory = new NullPriorityValue();
    private NullPriorityValue<DockTitleFactory> titleFactory = new NullPriorityValue();
    private NullPriorityValue<DockableMovingImageFactory> movingImage = new NullPriorityValue();
    private NullPriorityValue<StackDockComponentFactory> stackDockComponentFactory = new NullPriorityValue();
    private NullPriorityValue<TabPlacement> tabPlacement = new NullPriorityValue();
    private DockThemeExtension[] extensions;
    public static final PropertyKey<ColorScheme> BASIC_COLOR_SCHEME = new PropertyKey<ColorScheme>("dock.ui.BasicTheme.ColorScheme", new DynamicPropertyFactory<ColorScheme>(){

        @Override
        public ColorScheme getDefault(PropertyKey<ColorScheme> key, DockProperties properties) {
            return new BasicColorScheme();
        }
    }, true);
    private PropertyValue<ColorScheme> colorScheme = new PropertyValue<ColorScheme>(BASIC_COLOR_SCHEME){

        @Override
        protected void valueChanged(ColorScheme oldValue, ColorScheme newValue) {
            BasicTheme.this.updateColors();
        }
    };
    private NullPriorityValue<DockableSelection> selection = new NullPriorityValue();
    private DockController controller;
    private UIListener uiListener = new UIListener(){

        public void updateUI(DockController controller) {
            BasicTheme.this.updateUI();
        }

        public void themeChanged(DockController controller, DockTheme oldTheme, DockTheme newTheme) {
        }

        public void themeWillChange(DockController controller, DockTheme oldTheme, DockTheme newTheme) {
        }
    };

    public BasicTheme() {
        this.setCombiner(new BasicCombiner(), Priority.DEFAULT);
        this.setPaint(new BasicStationPaint(), Priority.DEFAULT);
        this.setDisplayerFactory(new BasicDisplayerFactory(), Priority.DEFAULT);
        this.setTitleFactory(new BasicDockTitleFactory(), Priority.DEFAULT);
        this.setMovingImageFactory(new BasicMovingImageFactory(), Priority.DEFAULT);
        this.setStackDockComponentFactory(new StackDockComponentFactory(){

            public StackDockComponent create(StackDockComponentParent station) {
                return new BasicStackDockComponent(station);
            }
        }, Priority.DEFAULT);
        this.setDockableSelection(new BasicDockableSelection(), Priority.DEFAULT);
        this.setTabPlacement(TabPlacement.BOTTOM_OF_DOCKABLE, Priority.DEFAULT);
    }

    @Override
    public void install(DockController controller, DockThemeExtension[] extensions) {
        this.extensions = extensions;
        for (DockThemeExtension extension : extensions) {
            extension.install(controller, this);
        }
        this.install(controller);
        for (DockThemeExtension extension : extensions) {
            extension.installed(controller, this);
        }
    }

    protected void install(DockController controller) {
        if (this.controller != null) {
            throw new IllegalStateException("Theme is already in use");
        }
        this.controller = controller;
        controller.getThemeManager().addUIListener(this.uiListener);
        this.updateUI();
        controller.getProperties().set(StackDockStation.COMPONENT_FACTORY, this.stackDockComponentFactory.get(), Priority.THEME);
        controller.getProperties().set(StackDockStation.TAB_PLACEMENT, this.tabPlacement.get(), Priority.THEME);
        this.colorScheme.setProperties(controller);
        this.updateColors();
    }

    @Override
    public void uninstall(DockController controller) {
        if (this.controller != controller) {
            throw new IllegalArgumentException("Trying to uninstall a controller which is not installed");
        }
        controller.getProperties().unset(StackDockStation.COMPONENT_FACTORY, Priority.THEME);
        controller.getProperties().unset(StackDockStation.TAB_PLACEMENT, Priority.THEME);
        controller.getColors().clear(Priority.THEME);
        controller.getThemeManager().removeUIListener(this.uiListener);
        this.colorScheme.setProperties((DockProperties)null);
        for (DockThemeExtension extension : this.extensions) {
            extension.uninstall(controller, this);
        }
        this.controller = null;
    }

    public void updateUI() {
        if (this.selection != null) {
            SwingUtilities.updateComponentTreeUI(this.selection.get().getComponent());
        }
    }

    protected void updateColors() {
        if (this.controller != null) {
            ColorScheme scheme = this.colorScheme.getValue();
            if (scheme != null) {
                scheme = new ExtendingColorScheme(scheme, this.controller);
            }
            this.controller.getColors().setScheme(Priority.THEME, scheme);
        }
    }

    public DockController getController() {
        return this.controller;
    }

    protected void setColorSchemeKey(PropertyKey<ColorScheme> key) {
        if (key == null) {
            throw new IllegalArgumentException("key must not be null");
        }
        this.colorScheme.setKey(key);
    }

    public void setColorScheme(ColorScheme colorScheme) {
        this.colorScheme.setValue(colorScheme);
    }

    public ColorScheme getColorScheme() {
        return this.colorScheme.getValue();
    }

    public void setStackDockComponentFactory(StackDockComponentFactory stackDockComponentFactory) {
        this.setStackDockComponentFactory(stackDockComponentFactory, Priority.CLIENT);
    }

    public void setStackDockComponentFactory(StackDockComponentFactory stackDockComponentFactory, Priority priority) {
        this.stackDockComponentFactory.set(priority, stackDockComponentFactory);
    }

    public void setMovingImageFactory(DockableMovingImageFactory movingImage) {
        this.setMovingImageFactory(movingImage, Priority.CLIENT);
    }

    public void setMovingImageFactory(DockableMovingImageFactory movingImage, Priority priority) {
        this.movingImage.set(priority, movingImage);
    }

    public void setCombiner(Combiner combiner) {
        this.setCombiner(combiner, Priority.CLIENT);
    }

    public void setCombiner(Combiner combiner, Priority priority) {
        this.combiner.set(priority, combiner);
    }

    public void setPaint(StationPaint paint) {
        this.setPaint(paint, Priority.CLIENT);
    }

    public void setPaint(StationPaint paint, Priority priority) {
        this.paint.set(priority, paint);
    }

    public void setDisplayerFactory(DisplayerFactory factory) {
        this.setDisplayerFactory(factory, Priority.CLIENT);
    }

    public void setDisplayerFactory(DisplayerFactory factory, Priority priority) {
        this.displayerFactory.set(priority, factory);
    }

    public void setTitleFactory(DockTitleFactory titleFactory) {
        this.setTitleFactory(titleFactory, Priority.CLIENT);
    }

    public void setTitleFactory(DockTitleFactory titleFactory, Priority priority) {
        this.titleFactory.set(priority, titleFactory);
        if (this.controller != null) {
            this.controller.getDockTitleManager().registerTheme("theme", this.titleFactory.get());
        }
    }

    public void setDockableSelection(DockableSelection selection) {
        this.setDockableSelection(selection, Priority.CLIENT);
    }

    public void setDockableSelection(DockableSelection selection, Priority priority) {
        this.selection.set(priority, selection);
    }

    public void setTabPlacement(TabPlacement tabPlacement) {
        this.setTabPlacement(tabPlacement, Priority.CLIENT);
    }

    public void setTabPlacement(TabPlacement tabPlacement, Priority priority) {
        this.tabPlacement.set(priority, tabPlacement);
    }

    public TabPlacement getTabPlacement() {
        return this.tabPlacement.get();
    }

    @Override
    public DockableMovingImageFactory getMovingImageFactory(DockController controller) {
        return this.movingImage.get();
    }

    @Override
    public Combiner getCombiner(DockStation station) {
        return this.combiner.get();
    }

    @Override
    public StationPaint getPaint(DockStation station) {
        return this.paint.get();
    }

    @Override
    public DisplayerFactory getDisplayFactory(DockStation station) {
        return this.displayerFactory.get();
    }

    @Override
    public DockTitleFactory getTitleFactory(DockController controller) {
        return this.titleFactory.get();
    }

    @Override
    public DockableSelection getDockableSelection(DockController controller) {
        return this.selection.get();
    }
}

