/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.common.group;

import bibliothek.gui.DockStation;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.StackDockStation;
import bibliothek.gui.dock.common.group.CGroupBehaviorCallback;
import bibliothek.gui.dock.common.group.CGroupMovement;
import bibliothek.gui.dock.common.mode.ExtendedMode;
import bibliothek.gui.dock.facile.mode.Location;
import bibliothek.gui.dock.layout.DockableProperty;
import bibliothek.gui.dock.station.stack.StackDockProperty;

public class StackGroupMovement
implements CGroupMovement {
    private StackDockStation dockParent;
    private Dockable dockable;
    private ExtendedMode target;
    private DockStation currentStation;
    private Dockable currentDockable;

    public StackGroupMovement(StackDockStation dockParent, Dockable dockable, ExtendedMode target) {
        this.dockParent = dockParent;
        this.dockable = dockable;
        this.target = target;
    }

    public void apply(CGroupBehaviorCallback callback) {
        Location movingLocation;
        int i;
        int baseIndex = this.dockParent.indexOf(this.dockable);
        Dockable[] children = new Dockable[this.dockParent.getDockableCount()];
        for (int i2 = 0; i2 < children.length; ++i2) {
            children[i2] = this.dockParent.getDockable(i2);
        }
        callback.setMode(this.dockable, this.target);
        boolean oneMissing = false;
        for (Dockable child : children) {
            if (child == this.dockable || callback.getManager().getMode(child) == this.target) continue;
            oneMissing = true;
            break;
        }
        if (!oneMissing) {
            return;
        }
        int missing = 0;
        for (i = baseIndex - 1; i >= 0; --i) {
            this.currentDockable = children[i];
            this.currentStation = this.dockable.getDockParent();
            Location base = callback.getLocation(this.dockable);
            movingLocation = new Location(base.getMode(), base.getRoot(), this.copyAndSetStackLocation(base.getLocation(), i - baseIndex + 1 - missing));
            callback.setLocation(this.currentDockable, movingLocation);
            if (this.currentDockable.getDockParent() == this.dockable.getDockParent()) continue;
            ++missing;
        }
        for (i = baseIndex + 1; i < children.length; ++i) {
            this.currentDockable = children[i];
            this.currentStation = this.dockable.getDockParent();
            Location base = callback.getLocation(this.dockable);
            movingLocation = new Location(base.getMode(), base.getRoot(), this.copyAndSetStackLocation(base.getLocation(), i - baseIndex - missing));
            callback.setLocation(this.currentDockable, movingLocation);
            if (this.currentDockable.getDockParent() == this.dockable.getDockParent()) continue;
            ++missing;
        }
        DockStation newParent = this.dockable.getDockParent();
        if (newParent instanceof StackDockStation) {
            newParent.setFrontDockable(this.dockable);
        }
        this.currentStation = null;
        this.currentDockable = null;
    }

    public boolean forceAccept(DockStation parent, Dockable child) {
        return parent != this.currentStation || child != this.currentDockable;
    }

    private DockableProperty copyAndSetStackLocation(DockableProperty property, int delta) {
        if (property == null) {
            return null;
        }
        DockableProperty last = property = property.copy();
        while (last.getSuccessor() != null) {
            last = last.getSuccessor();
        }
        if (last instanceof StackDockProperty) {
            ((StackDockProperty)last).setIndex(((StackDockProperty)last).getIndex() + delta);
        } else {
            StackDockProperty stack = new StackDockProperty(delta);
            last.setSuccessor((DockableProperty)stack);
        }
        return property;
    }
}

