/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.util;

import bibliothek.gui.dock.util.WindowProvider;
import bibliothek.gui.dock.util.WindowProviderListener;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractWindowProvider
implements WindowProvider {
    protected List<WindowProviderListener> listeners = new ArrayList<WindowProviderListener>();
    private Window window = null;
    private boolean windowShowing = false;
    private ComponentListener windowListener = new ComponentAdapter(){

        public void componentShown(ComponentEvent e) {
            AbstractWindowProvider.this.updateVisibility();
        }

        public void componentHidden(ComponentEvent e) {
            AbstractWindowProvider.this.updateVisibility();
        }
    };

    protected void updateVisibility() {
        boolean showing;
        Window current = this.searchWindow();
        if (this.window != current) {
            if (this.listeners.size() > 0) {
                if (this.window != null) {
                    this.window.removeComponentListener(this.windowListener);
                }
                if (current != null) {
                    current.addComponentListener(this.windowListener);
                }
            }
            this.window = current;
        }
        if (this.windowShowing != (showing = this.isShowing())) {
            this.windowShowing = showing;
            this.fireVisibilityChanged(showing);
        }
    }

    protected void fireWindowChanged(Window window) {
        this.updateVisibility();
        for (WindowProviderListener listener : this.listeners()) {
            listener.windowChanged(this, window);
        }
    }

    protected void fireVisibilityChanged(boolean showing) {
        for (WindowProviderListener listener : this.listeners()) {
            listener.visibilityChanged(this, showing);
        }
    }

    protected WindowProviderListener[] listeners() {
        return this.listeners.toArray(new WindowProviderListener[this.listeners.size()]);
    }

    public void addWindowProviderListener(WindowProviderListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("null is not allowed as listener");
        }
        if (this.listeners.size() == 0) {
            this.updateVisibility();
            if (this.window != null) {
                this.window.addComponentListener(this.windowListener);
            }
        }
        this.listeners.add(listener);
    }

    public void removeWindowProviderListener(WindowProviderListener listener) {
        this.listeners.remove(listener);
        if (this.listeners.size() == 0 && this.window != null) {
            this.window.removeComponentListener(this.windowListener);
        }
    }

    public boolean isShowing() {
        Window window = this.searchWindow();
        if (window == null) {
            return false;
        }
        return window.isShowing();
    }
}

