/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.extension.gui.dock.theme.eclipse.stack.tab;

import bibliothek.extension.gui.dock.theme.eclipse.EclipseDockActionSource;
import bibliothek.extension.gui.dock.theme.eclipse.stack.EclipseTab;
import bibliothek.extension.gui.dock.theme.eclipse.stack.EclipseTabPane;
import bibliothek.extension.gui.dock.theme.eclipse.stack.tab.TabComponent;
import bibliothek.gui.DockController;
import bibliothek.gui.DockStation;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.DockElement;
import bibliothek.gui.dock.station.stack.tab.Tab;
import bibliothek.gui.dock.station.stack.tab.TabPane;
import bibliothek.gui.dock.station.stack.tab.TabPaneComponent;
import bibliothek.gui.dock.station.stack.tab.TabPaneTabBackgroundComponent;
import bibliothek.gui.dock.station.stack.tab.layouting.TabPlacement;
import bibliothek.gui.dock.themes.basic.action.buttons.ButtonPanel;
import bibliothek.gui.dock.themes.color.TabColor;
import bibliothek.gui.dock.themes.font.TabFont;
import bibliothek.gui.dock.title.DockTitle;
import bibliothek.gui.dock.util.AbstractUIValue;
import bibliothek.gui.dock.util.BackgroundAlgorithm;
import bibliothek.gui.dock.util.BackgroundPanel;
import bibliothek.gui.dock.util.font.AbstractDockFont;
import bibliothek.gui.dock.util.font.FontModifier;
import bibliothek.gui.dock.util.swing.OrientedLabel;
import java.awt.Color;
import java.awt.Component;
import java.awt.ContainerOrderFocusTraversalPolicy;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputListener;

public abstract class BaseTabComponent
extends BackgroundPanel
implements TabComponent {
    protected final TabColor colorStackTabBorder;
    protected final TabColor colorStackTabBorderSelected;
    protected final TabColor colorStackTabBorderSelectedFocused;
    protected final TabColor colorStackTabBorderSelectedFocusLost;
    protected final TabColor colorStackTabTop;
    protected final TabColor colorStackTabTopSelected;
    protected final TabColor colorStackTabTopSelectedFocused;
    protected final TabColor colorStackTabTopSelectedFocusLost;
    protected final TabColor colorStackTabBottom;
    protected final TabColor colorStackTabBottomSelected;
    protected final TabColor colorStackTabBottomSelectedFocused;
    protected final TabColor colorStackTabBottomSelectedFocusLost;
    protected final TabColor colorStackTabText;
    protected final TabColor colorStackTabTextSelected;
    protected final TabColor colorStackTabTextSelectedFocused;
    protected final TabColor colorStackTabTextSelectedFocusLost;
    protected final TabColor colorStackBorder;
    protected final TabFont fontSelected;
    protected final TabFont fontFocused;
    protected final TabFont fontUnselected;
    private TabColor[] colors;
    private TabFont[] fonts;
    private Dockable dockable;
    private boolean paintIconWhenInactive = false;
    private Icon icon;
    private Insets buttonInsets = new Insets(0, 0, 0, 0);
    private ButtonPanel buttons;
    private boolean hasFocus;
    private boolean isSelected;
    private EclipseTabPane pane;
    private EclipseTab tab;
    private boolean bound;
    private Background background;
    private Insets labelInsets = new Insets(0, 0, 0, 0);
    private OrientedLabel label = new OrientedLabel();
    private TabPlacement orientation = TabPlacement.TOP_OF_DOCKABLE;
    private boolean previousTabSelectedSet = false;
    private boolean previousTabSelected = false;
    private boolean nextTabSelectedSet = false;
    private boolean nextTabSelected = false;

    public BaseTabComponent(EclipseTabPane pane, Dockable dockable) {
        this(pane, dockable, null);
    }

    public BaseTabComponent(EclipseTabPane pane, Dockable dockable, String colorPostfix) {
        super(null, false, false);
        if (pane == null) {
            throw new IllegalArgumentException("pane must not be null");
        }
        if (dockable == null) {
            throw new IllegalArgumentException("dockable must not be null");
        }
        this.pane = pane;
        this.dockable = dockable;
        this.add(this.label);
        DockStation station = pane.getStation();
        if (colorPostfix == null) {
            colorPostfix = "";
        }
        this.colorStackTabBorder = new BorderTabColor("stack.tab.border" + colorPostfix, station, Color.WHITE);
        this.colorStackTabBorderSelected = new BorderTabColor("stack.tab.border.selected" + colorPostfix, station, Color.WHITE);
        this.colorStackTabBorderSelectedFocused = new BorderTabColor("stack.tab.border.selected.focused" + colorPostfix, station, Color.WHITE);
        this.colorStackTabBorderSelectedFocusLost = new BorderTabColor("stack.tab.border.selected.focuslost" + colorPostfix, station, Color.WHITE);
        this.colorStackTabTop = new BaseTabColor("stack.tab.top" + colorPostfix, station, Color.LIGHT_GRAY);
        this.colorStackTabTopSelected = new BaseTabColor("stack.tab.top.selected" + colorPostfix, station, Color.LIGHT_GRAY);
        this.colorStackTabTopSelectedFocused = new BaseTabColor("stack.tab.top.selected.focused" + colorPostfix, station, Color.LIGHT_GRAY);
        this.colorStackTabTopSelectedFocusLost = new BaseTabColor("stack.tab.top.selected.focuslost" + colorPostfix, station, Color.LIGHT_GRAY);
        this.colorStackTabBottom = new BaseTabColor("stack.tab.bottom" + colorPostfix, station, Color.WHITE);
        this.colorStackTabBottomSelected = new BaseTabColor("stack.tab.bottom.selected" + colorPostfix, station, Color.WHITE);
        this.colorStackTabBottomSelectedFocused = new BaseTabColor("stack.tab.bottom.selected.focused" + colorPostfix, station, Color.WHITE);
        this.colorStackTabBottomSelectedFocusLost = new BaseTabColor("stack.tab.bottom.selected.focuslost" + colorPostfix, station, Color.WHITE);
        this.colorStackTabText = new BaseTabColor("stack.tab.text" + colorPostfix, station, Color.BLACK);
        this.colorStackTabTextSelected = new BaseTabColor("stack.tab.text.selected" + colorPostfix, station, Color.BLACK);
        this.colorStackTabTextSelectedFocused = new BaseTabColor("stack.tab.text.selected.focused" + colorPostfix, station, Color.BLACK);
        this.colorStackTabTextSelectedFocusLost = new BaseTabColor("stack.tab.text.selected.focuslost" + colorPostfix, station, Color.BLACK);
        this.colorStackBorder = new BaseTabColor("stack.border" + colorPostfix, station, Color.BLACK);
        this.fontFocused = new BaseTabFont("tab.focused", station);
        this.fontSelected = new BaseTabFont("tab.selected", station);
        this.fontUnselected = new BaseTabFont("tab.unselected", station);
        this.colors = new TabColor[]{this.colorStackTabBorder, this.colorStackTabBorderSelected, this.colorStackTabBorderSelectedFocused, this.colorStackTabBorderSelectedFocusLost, this.colorStackTabTop, this.colorStackTabTopSelected, this.colorStackTabTopSelectedFocused, this.colorStackTabTopSelectedFocusLost, this.colorStackTabBottom, this.colorStackTabBottomSelected, this.colorStackTabBottomSelectedFocused, this.colorStackTabBottomSelectedFocusLost, this.colorStackTabText, this.colorStackTabTextSelected, this.colorStackTabTextSelectedFocused, this.colorStackTabTextSelectedFocusLost, this.colorStackBorder};
        this.fonts = new TabFont[]{this.fontFocused, this.fontSelected, this.fontUnselected};
        this.setFocusable(false);
        this.setFocusTraversalPolicyProvider(true);
        this.setFocusTraversalPolicy(new ContainerOrderFocusTraversalPolicy());
        this.buttons = new ButtonPanel(false);
        this.add(this.buttons);
    }

    protected void addAdditionalColors(TabColor ... colors) {
        TabColor[] newColors = new TabColor[this.colors.length + colors.length];
        System.arraycopy(this.colors, 0, newColors, 0, this.colors.length);
        System.arraycopy(colors, 0, newColors, this.colors.length, colors.length);
        this.colors = newColors;
    }

    public abstract void updateBorder();

    protected void updateFont() {
        TabFont font = null;
        font = this.isFocused() ? this.fontFocused : (this.isSelected() ? this.fontSelected : this.fontUnselected);
        this.label.setFontModifier(font.font());
    }

    public abstract void updateFocus();

    protected abstract void updateSelected();

    protected abstract void updateColors();

    protected void updatePaintIcon() {
        if (this.isSelected() || this.doPaintIconWhenInactive()) {
            this.label.setIcon(this.icon);
        } else {
            this.label.setIcon(null);
        }
        this.revalidate();
        this.repaint();
    }

    protected abstract void updateOrientation();

    public void setTab(EclipseTab tab) {
        if (this.background != null) {
            this.background.setController(null);
            this.background = null;
        }
        this.tab = tab;
        if (this.bound) {
            this.background = new Background(tab);
            this.background.setController(this.getController());
        }
        this.setBackground(this.background);
    }

    public void bind() {
        if (this.buttons != null) {
            this.buttons.set(this.dockable, new EclipseDockActionSource(this.pane.getTheme(), this.dockable.getGlobalActionOffers(), this.dockable, true));
        }
        DockController controller = this.pane.getController();
        if (this.tab != null) {
            this.background = new Background(this.tab);
            this.background.setController(controller);
        }
        this.setBackground(this.background);
        for (TabColor tabColor : this.colors) {
            tabColor.connect(controller);
        }
        for (AbstractUIValue abstractUIValue : this.fonts) {
            ((AbstractDockFont)abstractUIValue).connect(controller);
        }
        this.revalidate();
        this.bound = true;
    }

    public void unbind() {
        this.bound = false;
        if (this.buttons != null) {
            this.buttons.set(null);
        }
        if (this.background != null) {
            this.background.setController(null);
            this.background = null;
        }
        this.setBackground(this.background);
        for (TabColor tabColor : this.colors) {
            tabColor.connect(null);
        }
        for (AbstractUIValue abstractUIValue : this.fonts) {
            ((AbstractDockFont)abstractUIValue).connect(null);
        }
    }

    public boolean isBound() {
        return this.bound;
    }

    public Dockable getDockable() {
        return this.dockable;
    }

    public DockElement getElement() {
        return this.dockable;
    }

    public boolean isUsedAsTitle() {
        return true;
    }

    public boolean shouldTransfersFocus() {
        return true;
    }

    public boolean shouldFocus() {
        return true;
    }

    public void addMouseInputListener(MouseInputListener listener) {
        this.addMouseListener(listener);
        this.addMouseMotionListener(listener);
    }

    public void removeMouseInputListener(MouseInputListener listener) {
        this.removeMouseListener(listener);
        this.removeMouseMotionListener(listener);
    }

    public synchronized void addMouseListener(MouseListener l) {
        super.addMouseListener(l);
        this.label.addMouseListener(l);
        this.buttons.addMouseListener(l);
    }

    public synchronized void removeMouseListener(MouseListener l) {
        super.removeMouseListener(l);
        this.label.removeMouseListener(l);
        this.buttons.removeMouseListener(l);
    }

    public synchronized void addMouseMotionListener(MouseMotionListener l) {
        super.addMouseMotionListener(l);
        this.label.addMouseMotionListener(l);
        this.buttons.addMouseMotionListener(l);
    }

    public synchronized void removeMouseMotionListener(MouseMotionListener l) {
        super.removeMouseMotionListener(l);
        this.label.removeMouseMotionListener(l);
        this.buttons.removeMouseMotionListener(l);
    }

    public Point getPopupLocation(Point click, boolean popupTrigger) {
        if (popupTrigger) {
            return click;
        }
        return null;
    }

    public DockController getController() {
        return this.pane.getController();
    }

    public DockStation getStation() {
        return this.pane.getStation();
    }

    public EclipseTabPane getPane() {
        return this.pane;
    }

    public Component getComponent() {
        return this;
    }

    public void setFocused(boolean focused) {
        if (this.hasFocus != focused) {
            this.hasFocus = focused;
            this.updateFocus();
        }
    }

    public boolean isFocused() {
        return this.hasFocus;
    }

    public boolean isFocusTemporarilyLost() {
        Window window = SwingUtilities.getWindowAncestor(this.getComponent());
        boolean focusTemporarilyLost = false;
        if (window != null) {
            focusTemporarilyLost = !window.isActive();
        }
        return focusTemporarilyLost;
    }

    public void setSelected(boolean selected) {
        if (this.isSelected != selected) {
            this.isSelected = selected;
            if (this.isSelected() || this.doPaintIconWhenInactive()) {
                this.label.setIcon(this.icon);
            } else {
                this.label.setIcon(null);
            }
            this.revalidate();
            this.updateSelected();
        }
    }

    public boolean isSelected() {
        return this.isSelected;
    }

    protected void setPreviousTabSelected(boolean selected) {
        this.previousTabSelected = selected;
        this.previousTabSelectedSet = true;
    }

    protected void cleanPreviousTabSelected() {
        this.previousTabSelectedSet = false;
    }

    protected boolean isPreviousTabSelected() {
        if (this.previousTabSelectedSet) {
            return this.previousTabSelected;
        }
        EclipseTabPane pane = this.getPane();
        pane.getSelectedIndex();
        int self = this.getTabIndex();
        if (self <= 0) {
            return false;
        }
        EclipseTab previous = (EclipseTab)pane.getVisibleTab(self - 1);
        return previous.getDockable() == pane.getSelectedDockable();
    }

    protected void setNextTabSelected(boolean selected) {
        this.nextTabSelected = selected;
        this.nextTabSelectedSet = true;
    }

    protected void cleanNextTabSelected() {
        this.nextTabSelectedSet = false;
    }

    protected boolean isNextTabSelected() {
        if (this.nextTabSelectedSet) {
            return this.nextTabSelected;
        }
        EclipseTabPane pane = this.getPane();
        int self = this.getTabIndex();
        if (self >= pane.getVisibleTabCount()) {
            return false;
        }
        EclipseTab next = (EclipseTab)pane.getVisibleTab(self + 1);
        if (next == null) {
            return false;
        }
        return next.getDockable() == pane.getSelectedDockable();
    }

    public int getDockableIndex() {
        EclipseTabPane pane = this.getPane();
        if (pane == null || !this.isBound()) {
            return -1;
        }
        return pane.indexOf(this.getDockable());
    }

    public int getTabIndex() {
        EclipseTabPane pane = this.getPane();
        if (pane == null || !this.isBound()) {
            return -1;
        }
        return pane.indexOfVisible(this);
    }

    public boolean doPaintIconWhenInactive() {
        return this.paintIconWhenInactive;
    }

    public void setPaintIconWhenInactive(boolean paintIconWhenInactive) {
        if (this.paintIconWhenInactive != paintIconWhenInactive) {
            this.paintIconWhenInactive = paintIconWhenInactive;
            this.updatePaintIcon();
        }
    }

    public void setIcon(Icon icon) {
        this.icon = icon;
        if (this.isSelected() || this.doPaintIconWhenInactive()) {
            this.label.setIcon(icon);
            this.revalidate();
        }
    }

    public Icon getIcon() {
        return this.label.getIcon();
    }

    public void setText(String text) {
        this.label.setText(text);
        this.revalidate();
    }

    public void setTooltip(String tooltip) {
        this.setToolTipText(tooltip);
    }

    public String getText() {
        return this.label.getText();
    }

    public void setLabelInsets(Insets labelInsets) {
        if (labelInsets == null) {
            throw new IllegalArgumentException("insets must not be null");
        }
        this.labelInsets = new Insets(labelInsets.top, labelInsets.left, labelInsets.bottom, labelInsets.right);
        this.revalidate();
    }

    public Insets getLabelInsets() {
        return this.labelInsets;
    }

    public void setButtonInsets(Insets buttonInsets) {
        if (buttonInsets == null) {
            throw new IllegalArgumentException("insets must not be null");
        }
        this.buttonInsets = buttonInsets;
        this.revalidate();
    }

    public Insets getButtonInsets() {
        return this.buttonInsets;
    }

    protected OrientedLabel getLabel() {
        return this.label;
    }

    public ButtonPanel getButtons() {
        return this.buttons;
    }

    public void setOrientation(TabPlacement orientation) {
        if (orientation == null) {
            throw new IllegalArgumentException("orientation must not be null");
        }
        if (this.orientation != orientation) {
            this.orientation = orientation;
            switch (orientation) {
                case TOP_OF_DOCKABLE: {
                    this.buttons.setOrientation(DockTitle.Orientation.NORTH_SIDED);
                    this.label.setHorizontal(true);
                    break;
                }
                case BOTTOM_OF_DOCKABLE: {
                    this.buttons.setOrientation(DockTitle.Orientation.SOUTH_SIDED);
                    this.label.setHorizontal(true);
                    break;
                }
                case LEFT_OF_DOCKABLE: {
                    this.buttons.setOrientation(DockTitle.Orientation.EAST_SIDED);
                    this.label.setHorizontal(false);
                    break;
                }
                case RIGHT_OF_DOCKABLE: {
                    this.buttons.setOrientation(DockTitle.Orientation.WEST_SIDED);
                    this.label.setHorizontal(false);
                }
            }
            this.updateOrientation();
        }
    }

    public TabPlacement getOrientation() {
        return this.orientation;
    }

    public Dimension getMinimumSize(TabComponent[] tabs) {
        this.setSelection(tabs);
        Dimension result = this.getMinimumSize();
        this.unsetSelection();
        return result;
    }

    public Dimension getPreferredSize(TabComponent[] tabs) {
        this.setSelection(tabs);
        Dimension result = this.getPreferredSize();
        this.unsetSelection();
        return result;
    }

    private void setSelection(TabComponent[] tabs) {
        Dockable selected = this.getPane().getSelectedDockable();
        for (int i = 0; i < tabs.length; ++i) {
            if (tabs[i] != this) continue;
            if (i > 0 && tabs[i - 1] instanceof BaseTabComponent) {
                this.setPreviousTabSelected(((BaseTabComponent)tabs[i - 1]).getDockable() == selected);
            }
            if (i + 1 >= tabs.length || !(tabs[i + 1] instanceof BaseTabComponent)) break;
            this.setNextTabSelected(((BaseTabComponent)tabs[i + 1]).getDockable() == selected);
            break;
        }
    }

    private void unsetSelection() {
        this.cleanNextTabSelected();
        this.cleanPreviousTabSelected();
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public Dimension getPreferredSize() {
        if (this.label == null) {
            return new Dimension(1, 1);
        }
        Dimension labelSize = this.label.getPreferredSize();
        Dimension buttonSize = this.buttons.getPreferredSize();
        if (this.orientation.isHorizontal()) {
            return new Dimension(labelSize.width + buttonSize.width + this.labelInsets.left + this.labelInsets.right + this.buttonInsets.left + this.buttonInsets.right, Math.max(labelSize.height + this.labelInsets.top + this.labelInsets.bottom, buttonSize.height + this.buttonInsets.top + this.buttonInsets.bottom));
        }
        return new Dimension(Math.max(labelSize.width + this.labelInsets.left + this.labelInsets.right, buttonSize.width + this.buttonInsets.left + this.buttonInsets.right), labelSize.height + buttonSize.height + this.labelInsets.top + this.labelInsets.bottom + this.buttonInsets.top + this.buttonInsets.bottom);
    }

    public void doLayout() {
        if (this.label != null && this.buttons != null) {
            Dimension labelSize = this.label.getPreferredSize();
            Dimension buttonSize = this.buttons.getPreferredSize();
            int width = this.getWidth();
            int height = this.getHeight();
            if (this.orientation.isHorizontal()) {
                int labelHeight = labelSize.height + this.labelInsets.top + this.labelInsets.bottom;
                int buttonHeight = buttonSize.height + this.buttonInsets.top + this.buttonInsets.bottom;
                this.label.setBounds(this.labelInsets.left, (height - labelHeight) / 2 + this.labelInsets.top, labelSize.width, labelSize.height);
                this.buttons.setBounds(width - buttonSize.width - this.buttonInsets.right, (height - buttonHeight) / 2 + this.buttonInsets.top, buttonSize.width, buttonSize.height);
            } else {
                int labelWidth = labelSize.width + this.labelInsets.left + this.labelInsets.right;
                int buttonWidth = buttonSize.width + this.buttonInsets.left + this.buttonInsets.right;
                this.label.setBounds((width - labelWidth) / 2 + this.labelInsets.left, this.labelInsets.top, labelSize.width, labelSize.height);
                this.buttons.setBounds((width - buttonWidth) / 2 + this.buttonInsets.left, height - buttonSize.height - this.buttonInsets.bottom, buttonSize.width, buttonSize.height);
            }
            this.repaint();
        }
    }

    private class Background
    extends BackgroundAlgorithm
    implements TabPaneTabBackgroundComponent {
        private EclipseTab tab;

        public Background(EclipseTab tab) {
            super(TabPaneTabBackgroundComponent.KIND, "dock.background.tabPane.child.tab");
            this.tab = tab;
        }

        public Tab getTab() {
            return this.tab;
        }

        public TabPaneComponent getChild() {
            return this.tab;
        }

        public TabPane getPane() {
            return this.tab.getTabParent();
        }

        public Component getComponent() {
            return BaseTabComponent.this.getComponent();
        }
    }

    private class BaseTabFont
    extends TabFont {
        public BaseTabFont(String id, DockStation station) {
            super(id, station, BaseTabComponent.this.dockable);
        }

        protected void changed(FontModifier oldValue, FontModifier newValue) {
            BaseTabComponent.this.updateFont();
        }
    }

    private class BaseTabColor
    extends TabColor {
        public BaseTabColor(String id, DockStation station, Color backup) {
            super(id, station, BaseTabComponent.this.dockable, backup);
        }

        protected void changed(Color oldColor, Color newColor) {
            BaseTabComponent.this.updateColors();
        }
    }

    private class BorderTabColor
    extends TabColor {
        public BorderTabColor(String id, DockStation station, Color backup) {
            super(id, station, BaseTabComponent.this.dockable, backup);
        }

        protected void changed(Color oldColor, Color newColor) {
            BaseTabComponent.this.updateBorder();
        }
    }
}

