% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GetAllSatellites.R
\name{GetAllSatellites}
\alias{GetAllSatellites}
\title{Gets all referenced satellites info}
\source{
\url{https://api.spectator.earth/#satellites}
}
\usage{
GetAllSatellites(positions = TRUE)
}
\arguments{
\item{positions}{logical indicating if the current position should be included. Default: TRUE}
}
\value{
If \code{positions} is \code{FALSE}, a data frame with following attributes:
\describe{
\item{\code{id}}{integer identifier}
\item{\code{name}}{character satellite name}
\item{\code{norad_id}}{integer satellite catalog number}
\item{\code{sensors}}{character type of sensors available on the satellite (SAR or Optical)}
\item{\code{open}}{logical whether the data produced by the satellite is freely accessible}
\item{\code{platform}}{character platform name}
}
If \code{positions} is \code{TRUE}, object of class '\code{sf}' with '\code{POINT}' geometry type,
with the same attributes as above.
}
\description{
Gets the information about all the satellites known in the Spectator Earth database,
and possibly their current positions.
}
\examples{
if(interactive()){
 library(sf)
 # get all satellites withe their positions
 pos <- GetAllSatellites(positions = TRUE)
 # do some nice graphs
 library(maps)
 map("world", fill = TRUE, col = "lightgrey")
 # show open data satellites in green
 plot(st_geometry(subset(pos, open == TRUE)), add = TRUE, col = "green", pch = 15)
 # show others in red
 plot(st_geometry(subset(pos, open == FALSE)), add = TRUE, col = "red", pch = 16)
 # add labels
 xy <- st_coordinates(pos)
 # shift labels up to be able to read them
 xy[, 2] <- xy[, 2] + 2 
 text(xy, labels = pos$name, cex = 0.5)
 }
}
\seealso{
\code{\link[spectator]{GetSatellite}}
}
