% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/makeSimulatedData.R
\name{makeSimulatedData}
\alias{makeSimulatedData}
\title{Create a simulated NMR spectral data}
\usage{
makeSimulatedData()
}
\value{
a list with 2 elements: data (The simulated NMR spectral data matrix) and label (Group label of each spectrum)
}
\description{
Generate an NMR spectral data for testing.
}
\details{
We generate a NMR spectral data sets that contains two group A and group B. 
One at around 300 has a single tip and the other at around 600 has double 
tips that intentionally contains biological variation. First, a single spectrum 
is created based on statistic information (mean, standard deviation of intensity) 
achieved from real NMR spectra. Then, we randomly shift the spectrum to maximum 50 
data points and add some biological and technical variations to each point intensity 
to the spectrum to create a new spectrum. The collection of spectra from each group 
is the final dataset.
}
\examples{
res <- makeSimulatedData();
X <- res$data;
groupLabel <- res$label;

}
\author{
Trung Nghia Vu
}
